/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.AddProperty;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangePropertyValue
extends Recipe {
    @Option(displayName="Key", description="The name of the property key whose value is to be changed.", example="junit.version")
    private final String key;
    @Option(displayName="Value", description="Value to apply to the matching property.", example="4.13")
    private final String newValue;
    @Option(displayName="Add if missing", description="Add the property if it is missing from the pom file.", required=false)
    private final @Nullable Boolean addIfMissing;
    @Option(displayName="Trust parent POM", description="Even if the parent defines a property with the same key, trust it even if the value isn't the same. Useful when you want to wait for the parent to have its value changed first. The parent is not trusted by default.", required=false)
    private final @Nullable Boolean trustParent;
    private final String displayName = "Change Maven project property value";
    private final String description = "Changes the specified Maven project property value leaving the key intact.";

    public String getInstanceNameSuffix() {
        return String.format("`%s=%s`", this.key, this.newValue);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                String myValue;
                String currentValue = this.getResolutionResult().getPom().getProperties().get(ChangePropertyValue.this.key);
                boolean trust = Boolean.TRUE.equals(ChangePropertyValue.this.trustParent);
                if (!trust && !ChangePropertyValue.this.newValue.equals(currentValue)) {
                    return (Xml)SearchResult.found((Tree)document);
                }
                if (trust && (myValue = this.getResolutionResult().getPom().getRequested().getProperties().get(ChangePropertyValue.this.key)) != null && !myValue.equals(ChangePropertyValue.this.newValue)) {
                    return (Xml)SearchResult.found((Tree)document);
                }
                return document;
            }
        }, (TreeVisitor)new MavenIsoVisitor<ExecutionContext>(){
            final String propertyName;
            {
                this.propertyName = ChangePropertyValue.this.key.replace("${", "").replace("}", "");
            }

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document d = super.visitDocument(document, ctx);
                if (Boolean.TRUE.equals(ChangePropertyValue.this.addIfMissing)) {
                    this.doAfterVisit(new AddProperty(ChangePropertyValue.this.key, ChangePropertyValue.this.newValue, true, false).getVisitor());
                }
                return d;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isPropertyTag() && this.propertyName.equals(tag.getName()) && !ChangePropertyValue.this.newValue.equals(tag.getValue().orElse(null))) {
                    this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, ChangePropertyValue.this.newValue));
                    this.maybeUpdateModel();
                }
                return super.visitTag(tag, ctx);
            }
        });
    }

    @Generated
    public ChangePropertyValue(String key, String newValue, @Nullable Boolean addIfMissing, @Nullable Boolean trustParent) {
        this.key = key;
        this.newValue = newValue;
        this.addIfMissing = addIfMissing;
        this.trustParent = trustParent;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getNewValue() {
        return this.newValue;
    }

    @Generated
    public @Nullable Boolean getAddIfMissing() {
        return this.addIfMissing;
    }

    @Generated
    public @Nullable Boolean getTrustParent() {
        return this.trustParent;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePropertyValue(key=" + this.getKey() + ", newValue=" + this.getNewValue() + ", addIfMissing=" + this.getAddIfMissing() + ", trustParent=" + this.getTrustParent() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyValue)) {
            return false;
        }
        ChangePropertyValue other = (ChangePropertyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addIfMissing = this.getAddIfMissing();
        Boolean other$addIfMissing = other.getAddIfMissing();
        if (this$addIfMissing == null ? other$addIfMissing != null : !((Object)this$addIfMissing).equals(other$addIfMissing)) {
            return false;
        }
        Boolean this$trustParent = this.getTrustParent();
        Boolean other$trustParent = other.getTrustParent();
        if (this$trustParent == null ? other$trustParent != null : !((Object)this$trustParent).equals(other$trustParent)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangePropertyValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addIfMissing = this.getAddIfMissing();
        result = result * 59 + ($addIfMissing == null ? 43 : ((Object)$addIfMissing).hashCode());
        Boolean $trustParent = this.getTrustParent();
        result = result * 59 + ($trustParent == null ? 43 : ((Object)$trustParent).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

