/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class ChangePluginDependencies
extends Recipe {
    private static final XPathMatcher PLUGINS_MATCHER = new XPathMatcher("/project/build/plugins");
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="org.openrewrite.maven")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="rewrite-maven-plugin")
    private final String artifactId;
    @Option(displayName="Dependencies", description="Plugin dependencies provided as dependency coordinates of format \"groupId:artifactId:version\". When supplying multiple coordinates separate them with \",\". Supplying `null` will remove any existing plugin dependencies.", example="org.openrewrite.recipe:rewrite-spring:1.0.0, org.openrewrite.recipe:rewrite-testing-frameworks:1.0.0", required=false)
    private final @Nullable String dependencies;
    private final String displayName = "Change Maven plugin dependencies";
    private final String description = "Applies the specified dependencies to a Maven plugin. Will not add the plugin if it does not already exist in the pom.";

    public String getInstanceNameSuffix() {
        return String.format("for `%s:%s`", this.groupId, this.artifactId);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Xml.Tag dependenciesTag = this.dependencies == null ? null : Xml.Tag.build((String)("<dependencies>\n" + Arrays.stream(this.dependencies.split(",")).map(String::trim).map(gav -> {
            String[] gavs = gav.split(":");
            return "<dependency>\n<groupId>" + gavs[0] + "</groupId>\n<artifactId>" + gavs[1] + "</artifactId>\n<version>" + gavs[2] + "</version>\n</dependency>";
        }).collect(Collectors.joining("\n")) + "\n</dependencies>\n"));
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Optional<Xml.Tag> maybePlugin;
                Xml.Tag plugins = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (PLUGINS_MATCHER.matches(this.getCursor()) && (maybePlugin = plugins.getChildren().stream().filter(plugin -> "plugin".equals(plugin.getName()) && ChangePluginDependencies.this.groupId.equals(plugin.getChildValue("groupId").orElse(null)) && ChangePluginDependencies.this.artifactId.equals(plugin.getChildValue("artifactId").orElse(null))).findAny()).isPresent()) {
                    Xml.Tag plugin2 = maybePlugin.get();
                    plugins = ChangePluginDependencies.this.dependencies == null ? FilterTagChildrenVisitor.filterChildren((Xml.Tag)plugins, (Xml.Tag)plugin2, child -> !(child instanceof Xml.Tag) || !"dependencies".equals(((Xml.Tag)child).getName())) : AddOrUpdateChild.addOrUpdateChild((Xml.Tag)plugins, (Xml.Tag)plugin2, (Xml.Tag)dependenciesTag, (Cursor)this.getCursor().getParentOrThrow());
                }
                return plugins;
            }
        };
    }

    @Generated
    public ChangePluginDependencies(String groupId, String artifactId, @Nullable String dependencies) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.dependencies = dependencies;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getDependencies() {
        return this.dependencies;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePluginDependencies(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", dependencies=" + this.getDependencies() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePluginDependencies)) {
            return false;
        }
        ChangePluginDependencies other = (ChangePluginDependencies)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$dependencies = this.getDependencies();
        String other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !this$dependencies.equals(other$dependencies)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangePluginDependencies;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : $dependencies.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

