/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class ChangeManagedDependencyGroupIdAndArtifactId
extends Recipe {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures(this);
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a managed dependency coordinate `com.google.guava:guava:VERSION`.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a managed dependency coordinate `com.google.guava:guava:VERSION`.", example="rewrite-testing-frameworks")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use.", example="corp.internal.openrewrite.recipe")
    private final String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use.", example="rewrite-testing-frameworks")
    private final String newArtifactId;
    @Option(displayName="New version", description="The new version to use.", example="2.0.0", required=false)
    private final @Nullable String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    private final String displayName = "Change Maven managed dependency groupId, artifactId and optionally the version";
    private final String description = "Change the groupId, artifactId and optionally the version of a specified Maven managed dependency.";

    public ChangeManagedDependencyGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, String newGroupId, String newArtifactId, @Nullable String newVersion) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = null;
    }

    @JsonCreator
    public ChangeManagedDependencyGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, String newGroupId, String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated.and(Validated.test((String)"coordinates", (String)"newGroupId OR newArtifactId must be different from before", (Object)((Object)this), r -> {
            boolean sameGroupId = StringUtils.isBlank((String)r.newGroupId) || Objects.equals(r.oldGroupId, r.newGroupId);
            boolean sameArtifactId = StringUtils.isBlank((String)r.newArtifactId) || Objects.equals(r.oldArtifactId, r.newArtifactId);
            return !sameGroupId || !sameArtifactId;
        }));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            final @Nullable VersionComparator versionComparator;
            private @Nullable Collection<String> availableVersions;
            private boolean isNewDependencyPresent;
            {
                this.versionComparator = ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion != null ? (VersionComparator)Semver.validate((String)ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion, (String)ChangeManagedDependencyGroupIdAndArtifactId.this.versionPattern).getValue() : null;
            }

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                this.isNewDependencyPresent = this.checkIfNewDependencyPresent(ChangeManagedDependencyGroupIdAndArtifactId.this.newGroupId, ChangeManagedDependencyGroupIdAndArtifactId.this.newArtifactId, ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion);
                return super.visitDocument(document, ctx);
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isManagedDependencyTag(ChangeManagedDependencyGroupIdAndArtifactId.this.oldGroupId, ChangeManagedDependencyGroupIdAndArtifactId.this.oldArtifactId)) {
                    t = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)t.getChild("groupId").orElse(null), ChangeManagedDependencyGroupIdAndArtifactId.this.newGroupId).visitNonNull((Tree)t, (Object)ctx);
                    t = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)t.getChild("artifactId").orElse(null), ChangeManagedDependencyGroupIdAndArtifactId.this.newArtifactId).visitNonNull((Tree)t, (Object)ctx);
                    if (ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion != null) {
                        try {
                            Optional versionTag = t.getChild("version");
                            if (versionTag.isPresent()) {
                                String resolvedArtifactId = ChangeManagedDependencyGroupIdAndArtifactId.this.newArtifactId;
                                if (resolvedArtifactId.contains("${")) {
                                    ResolvedPom pom = this.getResolutionResult().getPom();
                                    Map<String, String> properties = pom.getProperties();
                                    resolvedArtifactId = ResolvedPom.placeholderHelper.replacePlaceholders(ChangeManagedDependencyGroupIdAndArtifactId.this.newArtifactId, properties::get);
                                }
                                String resolvedNewVersion = this.resolveSemverVersion(ctx, ChangeManagedDependencyGroupIdAndArtifactId.this.newGroupId, resolvedArtifactId, this.getResolutionResult().getPom().getValue(((Xml.Tag)versionTag.get()).getValue().orElse(null)));
                                t = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)versionTag.get(), resolvedNewVersion).visitNonNull((Tree)t, (Object)ctx);
                            }
                        }
                        catch (MavenDownloadingException e) {
                            return e.warn(t);
                        }
                    }
                    if (t != tag) {
                        this.maybeUpdateModel();
                        this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, null, null).getVisitor());
                        if (this.isNewDependencyPresent) {
                            this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)t, true, true));
                            this.maybeUpdateModel();
                        }
                    }
                }
                return t;
            }

            private boolean checkIfNewDependencyPresent(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
                if (groupId == null || artifactId == null) {
                    return false;
                }
                ResolvedManagedDependency managedDependency = this.findManagedDependency(groupId, artifactId);
                if (managedDependency != null) {
                    return this.compareVersions(version, managedDependency.getVersion());
                }
                return false;
            }

            private boolean compareVersions(@Nullable String targetVersion, @Nullable String foundVersion) {
                if (targetVersion == null) {
                    return true;
                }
                if (this.versionComparator != null && foundVersion != null) {
                    return this.versionComparator.isValid(targetVersion, foundVersion);
                }
                return targetVersion.equals(foundVersion);
            }

            private String resolveSemverVersion(ExecutionContext ctx, String groupId, String artifactId, @Nullable String currentVersion) throws MavenDownloadingException {
                String finalCurrentVersion;
                if (this.versionComparator == null) {
                    return ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion;
                }
                String string = finalCurrentVersion = currentVersion != null ? currentVersion : ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion;
                if (this.availableVersions == null) {
                    this.availableVersions = new ArrayList<String>();
                    MavenMetadata mavenMetadata = ChangeManagedDependencyGroupIdAndArtifactId.this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(groupId, artifactId, ctx));
                    for (String v : mavenMetadata.getVersioning().getVersions()) {
                        if (!this.versionComparator.isValid(finalCurrentVersion, v)) continue;
                        this.availableVersions.add(v);
                    }
                }
                return this.availableVersions.isEmpty() ? ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion : Collections.max(this.availableVersions, this.versionComparator);
            }
        };
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Generated
    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Generated
    public String getNewGroupId() {
        return this.newGroupId;
    }

    @Generated
    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeManagedDependencyGroupIdAndArtifactId(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeManagedDependencyGroupIdAndArtifactId)) {
            return false;
        }
        ChangeManagedDependencyGroupIdAndArtifactId other = (ChangeManagedDependencyGroupIdAndArtifactId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeManagedDependencyGroupIdAndArtifactId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

