/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeExclusion
extends Recipe {
    @Option(displayName="Old groupId", description="The old groupId to replace. Supports glob expressions.", example="org.springframework")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. Supports glob expressions.", example="spring-web*")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use. Defaults to the existing group id.", example="org.springframework.boot", required=false)
    private final @Nullable String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use. Defaults to the existing artifact id.", example="spring-boot-starter-web", required=false)
    private final @Nullable String newArtifactId;

    public String getDisplayName() {
        return "Change Maven dependency exclusion";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.oldGroupId, this.oldArtifactId);
    }

    public String getDescription() {
        return "Modify Maven dependency exclusions, changing the group ID, artifact Id, or both. Useful when an excluded dependency has been renamed and references to it must be updated.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        validated = validated.and(Validated.required((String)"newGroupId", (Object)this.newGroupId).or(Validated.required((String)"newArtifactId", (Object)this.newArtifactId)));
        return validated.and(Validated.test((String)"coordinates", (String)"newGroupId OR newArtifactId must be different from before", (Object)((Object)this), r -> {
            boolean sameGroupId = StringUtils.isBlank((String)r.newGroupId) || r.oldGroupId.equals(r.newGroupId);
            boolean sameArtifactId = StringUtils.isBlank((String)r.newArtifactId) || r.oldArtifactId.equals(r.newArtifactId);
            return !sameGroupId || !sameArtifactId;
        }));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if ("exclusion".equals(t.getName()) && StringUtils.matchesGlob((String)t.getChildValue("groupId").orElse(null), (String)ChangeExclusion.this.oldGroupId) && StringUtils.matchesGlob((String)t.getChildValue("artifactId").orElse(null), (String)ChangeExclusion.this.oldArtifactId)) {
                    if (ChangeExclusion.this.newGroupId != null) {
                        t = this.changeChildTagValue(t, "groupId", ChangeExclusion.this.newGroupId, ctx);
                    }
                    if (ChangeExclusion.this.newArtifactId != null) {
                        t = this.changeChildTagValue(t, "artifactId", ChangeExclusion.this.newArtifactId, ctx);
                    }
                }
                if (t != tag) {
                    this.maybeUpdateModel();
                }
                return t;
            }
        };
    }

    @Generated
    public ChangeExclusion(String oldGroupId, String oldArtifactId, @Nullable String newGroupId, @Nullable String newArtifactId) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
    }

    @Generated
    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Generated
    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Generated
    public @Nullable String getNewGroupId() {
        return this.newGroupId;
    }

    @Generated
    public @Nullable String getNewArtifactId() {
        return this.newArtifactId;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeExclusion(oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeExclusion)) {
            return false;
        }
        ChangeExclusion other = (ChangeExclusion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        return !(this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeExclusion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        return result;
    }
}

