/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.tree.Xml;

public final class AddParentPom
extends Recipe {
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures(this);
    @Option(displayName="Group ID", description="The group ID of the maven parent pom to be adopted.", example="org.springframework.boot")
    private final String groupId;
    @Option(displayName="Artifact ID", description="The artifact ID of the maven parent pom to be adopted.", example="spring-boot-starter-parent")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String version;
    @Option(displayName="Relative path", description="New relative path attribute for parent lookup.", example="../pom.xml")
    private final @Nullable String relativePath;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    private final String displayName = "Add Maven parent";
    private final String description = "Add a parent pom to a Maven pom.xml. Does nothing if a parent pom is already present.";

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s:%s`", this.groupId, this.artifactId, this.version);
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Tag root = document.getRoot();
                if (!root.getChild("parent").isPresent()) {
                    return (Xml)SearchResult.found((Tree)document);
                }
                return document;
            }
        }, (TreeVisitor)new MavenIsoVisitor<ExecutionContext>(){
            private @Nullable Collection<String> availableVersions;
            private final VersionComparator versionComparator;
            {
                this.versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)AddParentPom.this.version, (String)AddParentPom.this.versionPattern).getValue());
            }

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Tag root = document.getRoot();
                assert (!root.getChild("parent").isPresent());
                try {
                    Optional<String> targetVersion = this.findAcceptableVersion(AddParentPom.this.groupId, AddParentPom.this.artifactId, ctx);
                    if (targetVersion.isPresent()) {
                        Xml.Tag parentTag = Xml.Tag.build((String)("<parent>\n<groupId>" + AddParentPom.this.groupId + "</groupId>\n<artifactId>" + AddParentPom.this.artifactId + "</artifactId>\n<version>" + targetVersion.get() + "</version>\n" + (AddParentPom.this.relativePath == null ? "" : (StringUtils.isBlank((String)AddParentPom.this.relativePath) ? "<relativePath/>" : "<relativePath>" + AddParentPom.this.relativePath + "</relativePath>")) + "</parent>"));
                        document = (Xml.Document)new AddToTagVisitor(root, parentTag, (Comparator)new MavenTagInsertionComparator(root.getChildren())).visitNonNull((Tree)document, (Object)ctx, this.getCursor().getParentOrThrow());
                        this.maybeUpdateModel();
                        this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, RemoveRedundantDependencyVersions.Comparator.GTE, null).getVisitor());
                    }
                }
                catch (MavenDownloadingException e) {
                    for (Map.Entry<MavenRepository, String> repositoryResponse : e.getRepositoryResponses().entrySet()) {
                        MavenRepository repository = repositoryResponse.getKey();
                        AddParentPom.this.metadataFailures.insertRow(ctx, new MavenMetadataFailures.Row(AddParentPom.this.groupId, AddParentPom.this.artifactId, AddParentPom.this.version, repository.getUri(), repository.getSnapshots(), repository.getReleases(), repositoryResponse.getValue()));
                    }
                    return e.warn(document);
                }
                return super.visitDocument(document, ctx);
            }

            private Optional<String> findAcceptableVersion(String groupId, String artifactId, ExecutionContext ctx) throws MavenDownloadingException {
                if (this.availableVersions == null) {
                    MavenMetadata mavenMetadata = AddParentPom.this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(groupId, artifactId, ctx));
                    this.availableVersions = mavenMetadata.getVersioning().getVersions().stream().filter(v -> this.versionComparator.isValid(null, v)).collect(Collectors.toList());
                }
                return this.availableVersions.stream().max((Comparator<String>)this.versionComparator);
            }
        });
    }

    @Generated
    public AddParentPom(String groupId, String artifactId, String version, @Nullable String relativePath, @Nullable String versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.relativePath = relativePath;
        this.versionPattern = versionPattern;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getRelativePath() {
        return this.relativePath;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddParentPom(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", relativePath=" + this.getRelativePath() + ", versionPattern=" + this.getVersionPattern() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddParentPom)) {
            return false;
        }
        AddParentPom other = (AddParentPom)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$relativePath = this.getRelativePath();
        String other$relativePath = other.getRelativePath();
        if (this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddParentPom;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $relativePath = this.getRelativePath();
        result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

