/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.Style;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Xml;

public final class AddDevelocityMavenExtension
extends ScanningRecipe<Accumulator> {
    private static final String GRADLE_ENTERPRISE_MAVEN_EXTENSION_ARTIFACT_ID = "gradle-enterprise-maven-extension";
    private static final String DEVELOCITY_MAVEN_EXTENSION_ARTIFACT_ID = "develocity-maven-extension";
    private static final String EXTENSIONS_XML_PATH = ".mvn/extensions.xml";
    private static final String GRADLE_ENTERPRISE_XML_PATH = ".mvn/gradle-enterprise.xml";
    private static final String DEVELOCITY_XML_PATH = ".mvn/develocity.xml";
    @Language(value="xml")
    private static final String EXTENSIONS_XML_FORMAT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<extensions>\n</extensions>";
    @Language(value="xml")
    private static final String EXTENSION_TAG_FORMAT = "<extension>\n  <groupId>com.gradle</groupId>\n  <artifactId>%s</artifactId>\n  <version>%s</version>\n</extension>";
    @Option(displayName="Extension version", description="A maven-compatible version number to select the gradle-enterprise-maven-extension version.", required=false, example="1.17.4")
    private final @Nullable String version;
    @Option(displayName="Server URL", description="The URL of the Develocity server.", example="https://scans.gradle.com/")
    private final String server;
    @Option(displayName="Allow untrusted server", description="When set to `true` the extension will be configured to allow unencrypted http connections with the server. If set to `false` or omitted, the extension will refuse to communicate without transport layer security enabled.", required=false, example="true")
    private final @Nullable Boolean allowUntrustedServer;
    @Option(displayName="Capture file fingerprints", description="When set to `true` the extension will capture additional information about the inputs to Maven goals. This increases the size of build scans, but is useful for diagnosing issues with goal caching. ", required=false, example="true")
    private final @Nullable Boolean fileFingerprints;
    @Option(displayName="Upload in background", description="When set to `false` the extension will not upload build scan in the background. By default, build scans are uploaded in the background after the build has finished to avoid blocking the build process.", required=false, example="false")
    private final @Nullable Boolean uploadInBackground;
    @Option(displayName="Publish Criteria", description="When set to `Always` the extension will publish build scans of every single build. This is the default behavior when omitted.When set to `Failure` the extension will only publish build scans when the build fails. When set to `Demand` the extension will only publish build scans when explicitly requested.", required=false, valid={"Always", "Failure", "Demand"}, example="Always")
    private final @Nullable PublishCriteria publishCriteria;
    private final String displayName = "Add the Develocity Maven extension";
    private final String description = "To integrate the Develocity Maven extension into Maven projects, ensure that the `develocity-maven-extension` is added to the `.mvn/extensions.xml` file if not already present. Additionally, configure the extension by adding the `.mvn/develocity.xml` configuration file.";

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                String sourcePath;
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                switch (sourcePath = PathUtils.separatorsToUnix((String)sourceFile.getSourcePath().toString())) {
                    case "pom.xml": {
                        acc.setMavenProject(true);
                        acc.setUseCRLFNewLines(((GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)sourceFile, () -> new GeneralFormatStyle(false))).isUseCRLFNewLines());
                        break;
                    }
                    case ".mvn/extensions.xml": {
                        if (!(sourceFile instanceof Xml.Document)) {
                            throw new RuntimeException("The extensions.xml is not xml document type");
                        }
                        acc.setMatchingExtensionsXmlFile(sourceFile.getSourcePath());
                        break;
                    }
                    case ".mvn/gradle-enterprise.xml": 
                    case ".mvn/develocity.xml": {
                        acc.setMatchingGradleEnterpriseXmlFile(sourceFile.getSourcePath());
                        break;
                    }
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        BuildScanConfiguration buildScanConfiguration;
        if (!acc.isMavenProject() || acc.getMatchingGradleEnterpriseXmlFile() != null) {
            return Collections.emptyList();
        }
        VersionComparator versionComparator = (VersionComparator)Semver.validate((String)"(,1.21)", null).getValue();
        if (versionComparator == null) {
            return Collections.emptyList();
        }
        String newVersion = this.version != null ? this.version : this.getLatestVersion(ctx);
        ArrayList<Xml.Document> sources = new ArrayList<Xml.Document>();
        if (versionComparator.compare(null, newVersion, "1.21") >= 0) {
            buildScanConfiguration = this.buildScanConfiguration(true);
            ServerConfiguration serverConfiguration = new ServerConfiguration(this.server, this.allowUntrustedServer);
            DevelocityConfiguration develocityConfiguration = new DevelocityConfiguration(serverConfiguration, buildScanConfiguration);
            sources.add(AddDevelocityMavenExtension.createNewXml(DEVELOCITY_XML_PATH, this.writeConfiguration(develocityConfiguration, acc.isUseCRLFNewLines())));
        } else {
            buildScanConfiguration = this.buildScanConfiguration(false);
            ServerConfiguration serverConfiguration = new ServerConfiguration(this.server, this.allowUntrustedServer);
            GradleEnterpriseConfiguration gradleEnterpriseConfiguration = new GradleEnterpriseConfiguration(serverConfiguration, buildScanConfiguration);
            sources.add(AddDevelocityMavenExtension.createNewXml(GRADLE_ENTERPRISE_XML_PATH, this.writeConfiguration(gradleEnterpriseConfiguration, acc.isUseCRLFNewLines())));
        }
        if (acc.getMatchingExtensionsXmlFile() == null) {
            Xml.Document extensionsXml = AddDevelocityMavenExtension.createNewXml(EXTENSIONS_XML_PATH, EXTENSIONS_XML_FORMAT);
            extensionsXml = this.addExtension(extensionsXml, ctx);
            sources.add(extensionsXml);
        }
        return sources;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        if (!acc.isMavenProject() || acc.getMatchingExtensionsXmlFile() == null) {
            return TreeVisitor.noop();
        }
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                if (sourceFile.getSourcePath().equals(acc.getMatchingExtensionsXmlFile())) {
                    Xml.Document extensionsXml = (Xml.Document)sourceFile;
                    boolean hasEnterpriseExtension = AddDevelocityMavenExtension.this.findExistingExtension(extensionsXml);
                    if (hasEnterpriseExtension) {
                        return sourceFile;
                    }
                    return AddDevelocityMavenExtension.this.addExtension(extensionsXml, ctx);
                }
                return tree;
            }
        };
    }

    private String writeConfiguration(Object config, boolean useCRLFNewLines) {
        try {
            ObjectMapper objectMapper = MavenXmlMapper.writeMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
            DefaultXmlPrettyPrinter pp = new DefaultXmlPrettyPrinter().withCustomNewLine(useCRLFNewLines ? "\r\n" : "\n");
            return objectMapper.writer((PrettyPrinter)pp).writeValueAsString(config);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private @Nullable BuildScanConfiguration buildScanConfiguration(boolean develocity) {
        if (this.uploadInBackground != null || this.publishCriteria != null || this.fileFingerprints != null) {
            if (develocity) {
                PublishingConfiguration publishing = null;
                if (this.publishCriteria != null) {
                    String onlyIf;
                    switch (this.publishCriteria.ordinal()) {
                        case 0: {
                            onlyIf = "true";
                            break;
                        }
                        case 1: {
                            onlyIf = "!buildResult.failures.empty";
                            break;
                        }
                        case 2: {
                            onlyIf = "false";
                            break;
                        }
                        default: {
                            throw new IllegalStateException("All options exhausted");
                        }
                    }
                    publishing = new PublishingConfiguration(onlyIf);
                }
                return new BuildScanConfiguration(this.uploadInBackground, null, publishing, this.fileFingerprints != null ? new Capture(null, this.fileFingerprints) : null);
            }
            return new BuildScanConfiguration(this.uploadInBackground, this.publishCriteria != null ? this.publishCriteria.xmlName : null, null, this.fileFingerprints != null ? new Capture(this.fileFingerprints, null) : null);
        }
        return null;
    }

    private static Xml.Document createNewXml(String filePath, @Language(value="xml") String fileContents) {
        XmlParser parser = new XmlParser();
        Xml.Document brandNewFile = parser.parse(new String[]{fileContents}).findFirst().map(Xml.Document.class::cast).orElseThrow(() -> new IllegalArgumentException("Unable to parse XML contents"));
        return brandNewFile.withSourcePath(Paths.get(filePath, new String[0]));
    }

    private boolean findExistingExtension(Xml.Document extensionsXml) {
        final XPathMatcher xPathMatcher = new XPathMatcher("/extensions/extension/artifactId");
        return ((AtomicBoolean)new XmlIsoVisitor<AtomicBoolean>(){

            public Xml.Tag visitTag(Xml.Tag tag, AtomicBoolean found) {
                Optional maybeArtifactId;
                if (found.get()) {
                    return tag;
                }
                tag = super.visitTag(tag, (Object)found);
                if (xPathMatcher.matches(this.getCursor()) && (maybeArtifactId = tag.getValue()).isPresent() && (AddDevelocityMavenExtension.GRADLE_ENTERPRISE_MAVEN_EXTENSION_ARTIFACT_ID.equals(maybeArtifactId.get()) || AddDevelocityMavenExtension.DEVELOCITY_MAVEN_EXTENSION_ARTIFACT_ID.equals(maybeArtifactId.get()))) {
                    found.set(true);
                }
                return tag;
            }
        }.reduce((Tree)extensionsXml, (Object)new AtomicBoolean())).get();
    }

    private Xml.Document addExtension(Xml.Document extensionsXml, ExecutionContext ctx) {
        VersionComparator versionComparator = (VersionComparator)Semver.validate((String)"(,1.21)", null).getValue();
        if (versionComparator == null) {
            return extensionsXml;
        }
        String newVersion = this.version != null ? this.version : this.getLatestVersion(ctx);
        String extension = versionComparator.compare(null, newVersion, "1.21") >= 0 ? DEVELOCITY_MAVEN_EXTENSION_ARTIFACT_ID : GRADLE_ENTERPRISE_MAVEN_EXTENSION_ARTIFACT_ID;
        String tagSource = String.format(EXTENSION_TAG_FORMAT, extension, newVersion);
        AddToTagVisitor addToTagVisitor = new AddToTagVisitor(extensionsXml.getRoot(), Xml.Tag.build((String)tagSource));
        return (Xml.Document)addToTagVisitor.visitNonNull((Tree)extensionsXml, (Object)ctx);
    }

    private String getLatestVersion(ExecutionContext ctx) {
        MavenExecutionContextView mctx = MavenExecutionContextView.view(ctx);
        MavenPomDownloader pomDownloader = new MavenPomDownloader(Collections.emptyMap(), ctx, mctx.getSettings(), mctx.getActiveProfiles());
        LatestRelease versionComparator = new LatestRelease(null);
        GroupArtifact develocityExtension = new GroupArtifact("com.gradle", DEVELOCITY_MAVEN_EXTENSION_ARTIFACT_ID);
        try {
            MavenMetadata extensionMetadata = pomDownloader.downloadMetadata(develocityExtension, null, Collections.singletonList(MavenRepository.MAVEN_CENTRAL));
            return extensionMetadata.getVersioning().getVersions().stream().filter(arg_0 -> AddDevelocityMavenExtension.lambda$getLatestVersion$1((VersionComparator)versionComparator, arg_0)).max((arg_0, arg_1) -> AddDevelocityMavenExtension.lambda$getLatestVersion$2((VersionComparator)versionComparator, arg_0, arg_1)).orElseThrow(() -> new IllegalStateException("Expected to find at least one Gradle Enterprise Maven extension version to select from."));
        }
        catch (MavenDownloadingException e) {
            throw new IllegalStateException("Could not download Maven metadata", e);
        }
    }

    @Generated
    public AddDevelocityMavenExtension(@Nullable String version, String server, @Nullable Boolean allowUntrustedServer, @Nullable Boolean fileFingerprints, @Nullable Boolean uploadInBackground, @Nullable PublishCriteria publishCriteria) {
        this.version = version;
        this.server = server;
        this.allowUntrustedServer = allowUntrustedServer;
        this.fileFingerprints = fileFingerprints;
        this.uploadInBackground = uploadInBackground;
        this.publishCriteria = publishCriteria;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public @Nullable Boolean getAllowUntrustedServer() {
        return this.allowUntrustedServer;
    }

    @Generated
    public @Nullable Boolean getFileFingerprints() {
        return this.fileFingerprints;
    }

    @Generated
    public @Nullable Boolean getUploadInBackground() {
        return this.uploadInBackground;
    }

    @Generated
    public @Nullable PublishCriteria getPublishCriteria() {
        return this.publishCriteria;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddDevelocityMavenExtension(version=" + this.getVersion() + ", server=" + this.getServer() + ", allowUntrustedServer=" + this.getAllowUntrustedServer() + ", fileFingerprints=" + this.getFileFingerprints() + ", uploadInBackground=" + this.getUploadInBackground() + ", publishCriteria=" + (Object)((Object)this.getPublishCriteria()) + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDevelocityMavenExtension)) {
            return false;
        }
        AddDevelocityMavenExtension other = (AddDevelocityMavenExtension)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$allowUntrustedServer = this.getAllowUntrustedServer();
        Boolean other$allowUntrustedServer = other.getAllowUntrustedServer();
        if (this$allowUntrustedServer == null ? other$allowUntrustedServer != null : !((Object)this$allowUntrustedServer).equals(other$allowUntrustedServer)) {
            return false;
        }
        Boolean this$fileFingerprints = this.getFileFingerprints();
        Boolean other$fileFingerprints = other.getFileFingerprints();
        if (this$fileFingerprints == null ? other$fileFingerprints != null : !((Object)this$fileFingerprints).equals(other$fileFingerprints)) {
            return false;
        }
        Boolean this$uploadInBackground = this.getUploadInBackground();
        Boolean other$uploadInBackground = other.getUploadInBackground();
        if (this$uploadInBackground == null ? other$uploadInBackground != null : !((Object)this$uploadInBackground).equals(other$uploadInBackground)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        PublishCriteria this$publishCriteria = this.getPublishCriteria();
        PublishCriteria other$publishCriteria = other.getPublishCriteria();
        if (this$publishCriteria == null ? other$publishCriteria != null : !((Object)((Object)this$publishCriteria)).equals((Object)other$publishCriteria)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddDevelocityMavenExtension;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowUntrustedServer = this.getAllowUntrustedServer();
        result = result * 59 + ($allowUntrustedServer == null ? 43 : ((Object)$allowUntrustedServer).hashCode());
        Boolean $fileFingerprints = this.getFileFingerprints();
        result = result * 59 + ($fileFingerprints == null ? 43 : ((Object)$fileFingerprints).hashCode());
        Boolean $uploadInBackground = this.getUploadInBackground();
        result = result * 59 + ($uploadInBackground == null ? 43 : ((Object)$uploadInBackground).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        PublishCriteria $publishCriteria = this.getPublishCriteria();
        result = result * 59 + ($publishCriteria == null ? 43 : ((Object)((Object)$publishCriteria)).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static /* synthetic */ int lambda$getLatestVersion$2(VersionComparator versionComparator, String v1, String v2) {
        return versionComparator.compare(null, v1, v2);
    }

    private static /* synthetic */ boolean lambda$getLatestVersion$1(VersionComparator versionComparator, String v) {
        return versionComparator.isValid(null, v);
    }

    public static class Accumulator {
        boolean mavenProject;
        boolean useCRLFNewLines;
        Path matchingExtensionsXmlFile;
        Path matchingGradleEnterpriseXmlFile;

        @Generated
        public Accumulator() {
        }

        @Generated
        public boolean isMavenProject() {
            return this.mavenProject;
        }

        @Generated
        public boolean isUseCRLFNewLines() {
            return this.useCRLFNewLines;
        }

        @Generated
        public Path getMatchingExtensionsXmlFile() {
            return this.matchingExtensionsXmlFile;
        }

        @Generated
        public Path getMatchingGradleEnterpriseXmlFile() {
            return this.matchingGradleEnterpriseXmlFile;
        }

        @Generated
        public void setMavenProject(boolean mavenProject) {
            this.mavenProject = mavenProject;
        }

        @Generated
        public void setUseCRLFNewLines(boolean useCRLFNewLines) {
            this.useCRLFNewLines = useCRLFNewLines;
        }

        @Generated
        public void setMatchingExtensionsXmlFile(Path matchingExtensionsXmlFile) {
            this.matchingExtensionsXmlFile = matchingExtensionsXmlFile;
        }

        @Generated
        public void setMatchingGradleEnterpriseXmlFile(Path matchingGradleEnterpriseXmlFile) {
            this.matchingGradleEnterpriseXmlFile = matchingGradleEnterpriseXmlFile;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isMavenProject() != other.isMavenProject()) {
                return false;
            }
            if (this.isUseCRLFNewLines() != other.isUseCRLFNewLines()) {
                return false;
            }
            Path this$matchingExtensionsXmlFile = this.getMatchingExtensionsXmlFile();
            Path other$matchingExtensionsXmlFile = other.getMatchingExtensionsXmlFile();
            if (this$matchingExtensionsXmlFile == null ? other$matchingExtensionsXmlFile != null : !((Object)this$matchingExtensionsXmlFile).equals(other$matchingExtensionsXmlFile)) {
                return false;
            }
            Path this$matchingGradleEnterpriseXmlFile = this.getMatchingGradleEnterpriseXmlFile();
            Path other$matchingGradleEnterpriseXmlFile = other.getMatchingGradleEnterpriseXmlFile();
            return !(this$matchingGradleEnterpriseXmlFile == null ? other$matchingGradleEnterpriseXmlFile != null : !((Object)this$matchingGradleEnterpriseXmlFile).equals(other$matchingGradleEnterpriseXmlFile));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Accumulator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMavenProject() ? 79 : 97);
            result = result * 59 + (this.isUseCRLFNewLines() ? 79 : 97);
            Path $matchingExtensionsXmlFile = this.getMatchingExtensionsXmlFile();
            result = result * 59 + ($matchingExtensionsXmlFile == null ? 43 : ((Object)$matchingExtensionsXmlFile).hashCode());
            Path $matchingGradleEnterpriseXmlFile = this.getMatchingGradleEnterpriseXmlFile();
            result = result * 59 + ($matchingGradleEnterpriseXmlFile == null ? 43 : ((Object)$matchingGradleEnterpriseXmlFile).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddDevelocityMavenExtension.Accumulator(mavenProject=" + this.isMavenProject() + ", useCRLFNewLines=" + this.isUseCRLFNewLines() + ", matchingExtensionsXmlFile=" + this.getMatchingExtensionsXmlFile() + ", matchingGradleEnterpriseXmlFile=" + this.getMatchingGradleEnterpriseXmlFile() + ")";
        }
    }

    private static final class BuildScanConfiguration {
        private final @Nullable Boolean backgroundBuildScanUpload;
        private final @Nullable String publish;
        private final @Nullable PublishingConfiguration publishing;
        private final @Nullable Capture capture;

        @Generated
        public BuildScanConfiguration(@Nullable Boolean backgroundBuildScanUpload, @Nullable String publish, @Nullable PublishingConfiguration publishing, @Nullable Capture capture) {
            this.backgroundBuildScanUpload = backgroundBuildScanUpload;
            this.publish = publish;
            this.publishing = publishing;
            this.capture = capture;
        }

        @Generated
        public @Nullable Boolean getBackgroundBuildScanUpload() {
            return this.backgroundBuildScanUpload;
        }

        @Generated
        public @Nullable String getPublish() {
            return this.publish;
        }

        @Generated
        public @Nullable PublishingConfiguration getPublishing() {
            return this.publishing;
        }

        @Generated
        public @Nullable Capture getCapture() {
            return this.capture;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BuildScanConfiguration)) {
                return false;
            }
            BuildScanConfiguration other = (BuildScanConfiguration)o;
            Boolean this$backgroundBuildScanUpload = this.getBackgroundBuildScanUpload();
            Boolean other$backgroundBuildScanUpload = other.getBackgroundBuildScanUpload();
            if (this$backgroundBuildScanUpload == null ? other$backgroundBuildScanUpload != null : !((Object)this$backgroundBuildScanUpload).equals(other$backgroundBuildScanUpload)) {
                return false;
            }
            String this$publish = this.getPublish();
            String other$publish = other.getPublish();
            if (this$publish == null ? other$publish != null : !this$publish.equals(other$publish)) {
                return false;
            }
            PublishingConfiguration this$publishing = this.getPublishing();
            PublishingConfiguration other$publishing = other.getPublishing();
            if (this$publishing == null ? other$publishing != null : !((Object)this$publishing).equals(other$publishing)) {
                return false;
            }
            Capture this$capture = this.getCapture();
            Capture other$capture = other.getCapture();
            return !(this$capture == null ? other$capture != null : !((Object)this$capture).equals(other$capture));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $backgroundBuildScanUpload = this.getBackgroundBuildScanUpload();
            result = result * 59 + ($backgroundBuildScanUpload == null ? 43 : ((Object)$backgroundBuildScanUpload).hashCode());
            String $publish = this.getPublish();
            result = result * 59 + ($publish == null ? 43 : $publish.hashCode());
            PublishingConfiguration $publishing = this.getPublishing();
            result = result * 59 + ($publishing == null ? 43 : ((Object)$publishing).hashCode());
            Capture $capture = this.getCapture();
            result = result * 59 + ($capture == null ? 43 : ((Object)$capture).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddDevelocityMavenExtension.BuildScanConfiguration(backgroundBuildScanUpload=" + this.getBackgroundBuildScanUpload() + ", publish=" + this.getPublish() + ", publishing=" + this.getPublishing() + ", capture=" + this.getCapture() + ")";
        }
    }

    private static final class ServerConfiguration {
        private final String url;
        private final @Nullable Boolean allowUntrusted;

        @Generated
        public ServerConfiguration(String url, @Nullable Boolean allowUntrusted) {
            this.url = url;
            this.allowUntrusted = allowUntrusted;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public @Nullable Boolean getAllowUntrusted() {
            return this.allowUntrusted;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerConfiguration)) {
                return false;
            }
            ServerConfiguration other = (ServerConfiguration)o;
            Boolean this$allowUntrusted = this.getAllowUntrusted();
            Boolean other$allowUntrusted = other.getAllowUntrusted();
            if (this$allowUntrusted == null ? other$allowUntrusted != null : !((Object)this$allowUntrusted).equals(other$allowUntrusted)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $allowUntrusted = this.getAllowUntrusted();
            result = result * 59 + ($allowUntrusted == null ? 43 : ((Object)$allowUntrusted).hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddDevelocityMavenExtension.ServerConfiguration(url=" + this.getUrl() + ", allowUntrusted=" + this.getAllowUntrusted() + ")";
        }
    }

    @JacksonXmlRootElement(localName="develocity")
    private static final class DevelocityConfiguration {
        private final ServerConfiguration server;
        private final @Nullable BuildScanConfiguration buildScan;

        @Generated
        public DevelocityConfiguration(ServerConfiguration server, @Nullable BuildScanConfiguration buildScan) {
            this.server = server;
            this.buildScan = buildScan;
        }

        @Generated
        public ServerConfiguration getServer() {
            return this.server;
        }

        @Generated
        public @Nullable BuildScanConfiguration getBuildScan() {
            return this.buildScan;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DevelocityConfiguration)) {
                return false;
            }
            DevelocityConfiguration other = (DevelocityConfiguration)o;
            ServerConfiguration this$server = this.getServer();
            ServerConfiguration other$server = other.getServer();
            if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
                return false;
            }
            BuildScanConfiguration this$buildScan = this.getBuildScan();
            BuildScanConfiguration other$buildScan = other.getBuildScan();
            return !(this$buildScan == null ? other$buildScan != null : !((Object)this$buildScan).equals(other$buildScan));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ServerConfiguration $server = this.getServer();
            result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
            BuildScanConfiguration $buildScan = this.getBuildScan();
            result = result * 59 + ($buildScan == null ? 43 : ((Object)$buildScan).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddDevelocityMavenExtension.DevelocityConfiguration(server=" + this.getServer() + ", buildScan=" + this.getBuildScan() + ")";
        }
    }

    @JacksonXmlRootElement(localName="gradleEnterprise")
    private static final class GradleEnterpriseConfiguration {
        private final ServerConfiguration server;
        private final @Nullable BuildScanConfiguration buildScan;

        @Generated
        public GradleEnterpriseConfiguration(ServerConfiguration server, @Nullable BuildScanConfiguration buildScan) {
            this.server = server;
            this.buildScan = buildScan;
        }

        @Generated
        public ServerConfiguration getServer() {
            return this.server;
        }

        @Generated
        public @Nullable BuildScanConfiguration getBuildScan() {
            return this.buildScan;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GradleEnterpriseConfiguration)) {
                return false;
            }
            GradleEnterpriseConfiguration other = (GradleEnterpriseConfiguration)o;
            ServerConfiguration this$server = this.getServer();
            ServerConfiguration other$server = other.getServer();
            if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
                return false;
            }
            BuildScanConfiguration this$buildScan = this.getBuildScan();
            BuildScanConfiguration other$buildScan = other.getBuildScan();
            return !(this$buildScan == null ? other$buildScan != null : !((Object)this$buildScan).equals(other$buildScan));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ServerConfiguration $server = this.getServer();
            result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
            BuildScanConfiguration $buildScan = this.getBuildScan();
            result = result * 59 + ($buildScan == null ? 43 : ((Object)$buildScan).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddDevelocityMavenExtension.GradleEnterpriseConfiguration(server=" + this.getServer() + ", buildScan=" + this.getBuildScan() + ")";
        }
    }

    public static enum PublishCriteria {
        Always("ALWAYS"),
        Failure("ON_FAILURE"),
        Demand("ON_DEMAND");

        private final String xmlName;

        private PublishCriteria(String xmlName) {
            this.xmlName = xmlName;
        }
    }

    private static final class PublishingConfiguration {
        private final @Nullable String onlyIf;

        @Generated
        public PublishingConfiguration(@Nullable String onlyIf) {
            this.onlyIf = onlyIf;
        }

        @Generated
        public @Nullable String getOnlyIf() {
            return this.onlyIf;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PublishingConfiguration)) {
                return false;
            }
            PublishingConfiguration other = (PublishingConfiguration)o;
            String this$onlyIf = this.getOnlyIf();
            String other$onlyIf = other.getOnlyIf();
            return !(this$onlyIf == null ? other$onlyIf != null : !this$onlyIf.equals(other$onlyIf));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $onlyIf = this.getOnlyIf();
            result = result * 59 + ($onlyIf == null ? 43 : $onlyIf.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddDevelocityMavenExtension.PublishingConfiguration(onlyIf=" + this.getOnlyIf() + ")";
        }
    }

    private static final class Capture {
        private final Boolean goalInputFiles;
        private final Boolean fileFingerprints;

        @Generated
        public Capture(Boolean goalInputFiles, Boolean fileFingerprints) {
            this.goalInputFiles = goalInputFiles;
            this.fileFingerprints = fileFingerprints;
        }

        @Generated
        public Boolean getGoalInputFiles() {
            return this.goalInputFiles;
        }

        @Generated
        public Boolean getFileFingerprints() {
            return this.fileFingerprints;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Capture)) {
                return false;
            }
            Capture other = (Capture)o;
            Boolean this$goalInputFiles = this.getGoalInputFiles();
            Boolean other$goalInputFiles = other.getGoalInputFiles();
            if (this$goalInputFiles == null ? other$goalInputFiles != null : !((Object)this$goalInputFiles).equals(other$goalInputFiles)) {
                return false;
            }
            Boolean this$fileFingerprints = this.getFileFingerprints();
            Boolean other$fileFingerprints = other.getFileFingerprints();
            return !(this$fileFingerprints == null ? other$fileFingerprints != null : !((Object)this$fileFingerprints).equals(other$fileFingerprints));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $goalInputFiles = this.getGoalInputFiles();
            result = result * 59 + ($goalInputFiles == null ? 43 : ((Object)$goalInputFiles).hashCode());
            Boolean $fileFingerprints = this.getFileFingerprints();
            result = result * 59 + ($fileFingerprints == null ? 43 : ((Object)$fileFingerprints).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddDevelocityMavenExtension.Capture(goalInputFiles=" + this.getGoalInputFiles() + ", fileFingerprints=" + this.getFileFingerprints() + ")";
        }
    }
}

