/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.cleanup;

import java.time.Duration;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.kotlin.KotlinVisitor;

public class UnnecessaryTypeParentheses
extends Recipe {
    final String displayName = "Remove unnecessary parentheses on Kotlin types";
    final String description = "In Kotlin, it's possible to add redundant nested parentheses in type definitions. This recipe is designed to remove those unnecessary parentheses.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(3L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinVisitor<ExecutionContext>(){

            public J visitParenthesizedTypeTree(J.ParenthesizedTypeTree parTree, ExecutionContext ctx) {
                J j = super.visitParenthesizedTypeTree(parTree, (Object)ctx);
                if (!(j instanceof J.ParenthesizedTypeTree)) {
                    return j;
                }
                Space prefix = j.getPrefix();
                TypeTree tt = (TypeTree)j;
                while (tt instanceof J.ParenthesizedTypeTree) {
                    tt = (TypeTree)((J.ParenthesizedTypeTree)tt).getParenthesizedType().getTree();
                }
                return tt.withPrefix(prefix);
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

