/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.kotlin.KotlinVisitor;

public final class ImplicitParameterInLambda
extends Recipe {
    private final String displayName = "`it` shouldn't be used as a lambda parameter name";
    private final String description = "`it` is a special identifier that allows you to refer to the current parameter being passed to a lambda expression without explicitly naming the parameter. Lambda expressions are a concise way of writing anonymous functions. Many lambda expressions have only one parameter, when this is true the compiler can determine the parameter type by context. Thus when using it with single parameter lambda expressions, you do not need to declare the type.";
    private final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(2L);
    private final Set<String> tags = Collections.singleton("RSPEC-S6558");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinVisitor<ExecutionContext>(){

            public J visitLambda(J.Lambda lambda, ExecutionContext ctx) {
                if (ImplicitParameterInLambda.isParameterExplicitIt(lambda = (J.Lambda)super.visitLambda(lambda, (Object)ctx))) {
                    lambda = lambda.withParameters(lambda.getParameters().withParameters(Collections.emptyList()));
                    return this.autoFormat((J)lambda, ctx);
                }
                return lambda;
            }
        };
    }

    private static boolean isParameterExplicitIt(J.Lambda lambda) {
        J.Lambda.Parameters parameters = lambda.getParameters();
        if (parameters.getParameters().size() != 1) {
            return false;
        }
        J parameter = (J)parameters.getParameters().get(0);
        if (parameter instanceof J.VariableDeclarations) {
            J.VariableDeclarations vs = (J.VariableDeclarations)parameter;
            if (vs.getVariables().size() != 1 || vs.getTypeExpression() != null) {
                return false;
            }
            J.VariableDeclarations.NamedVariable v = (J.VariableDeclarations.NamedVariable)vs.getVariables().get(0);
            return "it".equals(v.getSimpleName());
        }
        return false;
    }

    @Generated
    public ImplicitParameterInLambda() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ImplicitParameterInLambda(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", estimatedEffortPerOccurrence=" + this.getEstimatedEffortPerOccurrence() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImplicitParameterInLambda)) {
            return false;
        }
        ImplicitParameterInLambda other = (ImplicitParameterInLambda)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Duration this$estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        Duration other$estimatedEffortPerOccurrence = other.getEstimatedEffortPerOccurrence();
        if (this$estimatedEffortPerOccurrence == null ? other$estimatedEffortPerOccurrence != null : !((Object)this$estimatedEffortPerOccurrence).equals(other$estimatedEffortPerOccurrence)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ImplicitParameterInLambda;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Duration $estimatedEffortPerOccurrence = this.getEstimatedEffortPerOccurrence();
        result = result * 59 + ($estimatedEffortPerOccurrence == null ? 43 : ((Object)$estimatedEffortPerOccurrence).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }
}

