/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.header;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrewrite.tools.checkstyle.PropertyType;
import org.openrewrite.tools.checkstyle.XdocsPropertyType;
import org.openrewrite.tools.checkstyle.api.AbstractFileSetCheck;
import org.openrewrite.tools.checkstyle.api.CheckstyleException;
import org.openrewrite.tools.checkstyle.api.ExternalResourceHolder;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;

public abstract class AbstractHeaderCheck
extends AbstractFileSetCheck
implements ExternalResourceHolder {
    private static final Pattern ESCAPED_LINE_FEED_PATTERN = Pattern.compile("\\\\n");
    private final List<String> readerLines = new ArrayList<String>();
    private URI headerFile;
    @XdocsPropertyType(value=PropertyType.STRING)
    private Charset charset = AbstractHeaderCheck.createCharset(System.getProperty("file.encoding", StandardCharsets.UTF_8.name()));

    protected abstract void postProcessHeaderLines();

    protected List<String> getHeaderLines() {
        ArrayList<String> copy = new ArrayList<String>(this.readerLines);
        return Collections.unmodifiableList(copy);
    }

    public void setCharset(String charset) {
        this.charset = AbstractHeaderCheck.createCharset(charset);
    }

    public void setHeaderFile(URI uri) throws CheckstyleException {
        if (uri == null) {
            throw new CheckstyleException("property 'headerFile' is missing or invalid in module " + this.getConfiguration().getName());
        }
        this.headerFile = uri;
    }

    private void loadHeaderFile() throws CheckstyleException {
        this.checkHeaderNotInitialized();
        try (InputStreamReader headerReader = new InputStreamReader((InputStream)new BufferedInputStream(this.headerFile.toURL().openStream()), this.charset);){
            this.loadHeader(headerReader);
        }
        catch (IOException ex) {
            throw new CheckstyleException("unable to load header file " + this.headerFile, ex);
        }
    }

    private void checkHeaderNotInitialized() {
        if (!this.readerLines.isEmpty()) {
            throw new IllegalArgumentException("header has already been set - set either header or headerFile, not both");
        }
    }

    private static Charset createCharset(String name) {
        if (!Charset.isSupported(name)) {
            String message = "unsupported charset: '" + name + "'";
            throw new UnsupportedCharsetException(message);
        }
        return Charset.forName(name);
    }

    public void setHeader(String header) {
        if (!CommonUtil.isBlank(header)) {
            this.checkHeaderNotInitialized();
            String headerExpandedNewLines = ESCAPED_LINE_FEED_PATTERN.matcher(header).replaceAll("\n");
            try (StringReader headerReader = new StringReader(headerExpandedNewLines);){
                this.loadHeader(headerReader);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("unable to load header", ex);
            }
        }
    }

    private void loadHeader(Reader headerReader) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(headerReader);){
            String line;
            do {
                if ((line = lnr.readLine()) == null) continue;
                this.readerLines.add(line);
            } while (line != null);
            this.postProcessHeaderLines();
        }
    }

    @Override
    protected final void finishLocalSetup() throws CheckstyleException {
        if (this.headerFile != null) {
            this.loadHeaderFile();
        }
    }

    @Override
    public Set<String> getExternalResourceLocations() {
        Set<String> result = this.headerFile == null ? Collections.emptySet() : Collections.singleton(this.headerFile.toString());
        return result;
    }
}

