/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.api;

import java.io.File;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openrewrite.tools.checkstyle.api.AbstractViolationReporter;
import org.openrewrite.tools.checkstyle.api.CheckstyleException;
import org.openrewrite.tools.checkstyle.api.FileContents;
import org.openrewrite.tools.checkstyle.api.FileSetCheck;
import org.openrewrite.tools.checkstyle.api.FileText;
import org.openrewrite.tools.checkstyle.api.MessageDispatcher;
import org.openrewrite.tools.checkstyle.api.Violation;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;

public abstract class AbstractFileSetCheck
extends AbstractViolationReporter
implements FileSetCheck {
    private final ThreadLocal<FileContext> context = ThreadLocal.withInitial(() -> new FileContext());
    private MessageDispatcher messageDispatcher;
    private String[] fileExtensions = CommonUtil.EMPTY_STRING_ARRAY;
    private int tabWidth = 8;

    protected abstract void processFiltered(File var1, FileText var2) throws CheckstyleException;

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
        this.context.remove();
    }

    @Override
    public void beginProcessing(String charset) {
    }

    @Override
    public final SortedSet<Violation> process(File file, FileText fileText) throws CheckstyleException {
        SortedSet violations = this.context.get().violations;
        this.context.get().fileContents = new FileContents(fileText);
        violations.clear();
        if (CommonUtil.matchesFileExtension(file, this.fileExtensions)) {
            this.processFiltered(file, fileText);
        }
        TreeSet<Violation> result = new TreeSet<Violation>(violations);
        violations.clear();
        return result;
    }

    @Override
    public void finishProcessing() {
    }

    @Override
    public final void setMessageDispatcher(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
    }

    protected final MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public SortedSet<Violation> getViolations() {
        return new TreeSet<Violation>(this.context.get().violations);
    }

    public final void setFileContents(FileContents contents) {
        this.context.get().fileContents = contents;
    }

    protected final FileContents getFileContents() {
        return this.context.get().fileContents;
    }

    public String[] getFileExtensions() {
        return Arrays.copyOf(this.fileExtensions, this.fileExtensions.length);
    }

    public final void setFileExtensions(String ... extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException("Extensions array can not be null");
        }
        this.fileExtensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            this.fileExtensions[i] = CommonUtil.startsWithChar(extension, '.') ? extension : "." + extension;
        }
    }

    protected final int getTabWidth() {
        return this.tabWidth;
    }

    public final void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    protected void addViolations(SortedSet<Violation> violations) {
        this.context.get().violations.addAll(violations);
    }

    @Override
    public final void log(int line, String key, Object ... args) {
        this.context.get().violations.add(new Violation(line, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    @Override
    public final void log(int lineNo, int colNo, String key, Object ... args) {
        int col = 1 + CommonUtil.lengthExpandedTabs(this.context.get().fileContents.getLine(lineNo - 1), colNo, this.tabWidth);
        this.context.get().violations.add(new Violation(lineNo, col, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    protected final void fireErrors(String fileName) {
        TreeSet<Violation> errors = new TreeSet<Violation>(this.context.get().violations);
        this.context.get().violations.clear();
        this.messageDispatcher.fireErrors(fileName, errors);
    }

    private static class FileContext {
        private final SortedSet<Violation> violations = new TreeSet<Violation>();
        private FileContents fileContents;

        private FileContext() {
        }
    }
}

