/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.search.UsesType;

public final class HasType
extends Recipe {
    @Option(displayName="Fully-qualified type name", description="A fully-qualified type name, that is used to find matching type references. Supports glob expressions. `java..*` finds every type from every subpackage of the `java` package.", example="java.util.List")
    private final String fullyQualifiedTypeName;
    @Option(displayName="Check for assignability", description="When enabled, find type references that are assignable to the provided type.", required=false)
    private final @Nullable Boolean checkAssignability;
    private final String displayName = "Find files that have at least one use of a type";
    private final String description = "Marks files that have at least one occurrence of a type, even if the name of that type doesn't appear in the source code.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new UsesType<ExecutionContext>(this.fullyQualifiedTypeName, this.checkAssignability);
    }

    @Generated
    public HasType(String fullyQualifiedTypeName, @Nullable Boolean checkAssignability) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
        this.checkAssignability = checkAssignability;
    }

    @Generated
    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    @Generated
    public @Nullable Boolean getCheckAssignability() {
        return this.checkAssignability;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "HasType(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ", checkAssignability=" + this.getCheckAssignability() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasType)) {
            return false;
        }
        HasType other = (HasType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$checkAssignability = this.getCheckAssignability();
        Boolean other$checkAssignability = other.getCheckAssignability();
        if (this$checkAssignability == null ? other$checkAssignability != null : !((Object)this$checkAssignability).equals(other$checkAssignability)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        if (this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof HasType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $checkAssignability = this.getCheckAssignability();
        result = result * 59 + ($checkAssignability == null ? 43 : ((Object)$checkAssignability).hashCode());
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

