/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class HasBuildToolVersion
extends Recipe {
    @Option(displayName="Build tool type", description="The build tool to search for.", example="Maven")
    private final BuildTool.Type type;
    @Option(displayName="Build tool version", description="An exact version number or node-style semver selector used to select the version number.", example="3.6.0-9999")
    private final String version;
    private final String displayName = "Find files with a particular build tool version";
    private final String description = "Finds Java source files built with a particular build tool. This is useful especially as a precondition for other recipes.";

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, null));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)this.version, null).getValue());
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree != null) {
                    return tree.getMarkers().findFirst(BuildTool.class).filter(buildTool -> buildTool.getType() == HasBuildToolVersion.this.type).filter(buildTool -> versionComparator.isValid(null, buildTool.getVersion())).map(version -> SearchResult.found((Tree)tree)).orElse(tree);
                }
                return tree;
            }
        };
    }

    @Generated
    public HasBuildToolVersion(BuildTool.Type type, String version) {
        this.type = type;
        this.version = version;
    }

    @Generated
    public BuildTool.Type getType() {
        return this.type;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "HasBuildToolVersion(type=" + this.getType() + ", version=" + this.getVersion() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasBuildToolVersion)) {
            return false;
        }
        HasBuildToolVersion other = (HasBuildToolVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        BuildTool.Type this$type = this.getType();
        BuildTool.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof HasBuildToolVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BuildTool.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

