/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class FindComments
extends Recipe {
    @Option(displayName="Text patterns", description="A list of regular expressions to search for.", example="-----BEGIN RSA PRIVATE KEY-----")
    private final List<String> patterns;
    private final String displayName = "Find within comments and literals";
    private final String description = "Find regular expression matches within comments and literals. \"Literals\" includes string literals, character literals, and numeric literals.";

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"patterns", (String)"Patterns must be compilable regular expressions", this.patterns, ps -> {
            for (String p : ps) {
                try {
                    Pattern.compile(p);
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
            return true;
        }));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final List compiledPatterns = this.patterns.stream().map(Pattern::compile).collect(Collectors.toList());
        return new JavaIsoVisitor<ExecutionContext>(){
            private final JavadocVisitor<ExecutionContext> javadocVisitor = new JavadocVisitor<ExecutionContext>((JavaVisitor)this){

                @Override
                public Javadoc visitText(Javadoc.Text text, ExecutionContext ctx) {
                    return (Javadoc)this.match(text, text.getText());
                }
            };

            @Override
            protected JavadocVisitor<ExecutionContext> getJavadocVisitor() {
                return this.javadocVisitor;
            }

            @Override
            public Space visitSpace(Space space, Space.Location loc, ExecutionContext ctx) {
                return space.withComments(ListUtils.map(space.getComments(), comment -> {
                    if (comment instanceof TextComment) {
                        for (Pattern p : compiledPatterns) {
                            if (!p.matcher(((TextComment)comment).getText()).find()) continue;
                            return comment.withMarkers(comment.getMarkers().computeByType((Marker)new SearchResult(Tree.randomId(), null), (s1, s2) -> s1 == null ? s2 : s1));
                        }
                    } else if (comment instanceof Javadoc.DocComment) {
                        return (Comment)((Object)this.getJavadocVisitor().visitDocComment((Javadoc.DocComment)comment, ctx));
                    }
                    return comment;
                }));
            }

            @Override
            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                J.Literal matched;
                if (literal.getType() == JavaType.Primitive.Null) {
                    return literal;
                }
                J.Literal literal2 = matched = literal.getValue() != null ? this.match(literal, literal.getValue().toString()) : literal;
                if (matched != literal) {
                    return matched;
                }
                return this.match(literal, literal.getValueSource());
            }

            private <T extends Tree> T match(T t, @Nullable String value) {
                if (value == null) {
                    return t;
                }
                for (Pattern p : compiledPatterns) {
                    if (!p.matcher(value).find()) continue;
                    return (T)SearchResult.found(t);
                }
                return t;
            }
        };
    }

    @Generated
    public FindComments(List<String> patterns) {
        this.patterns = patterns;
    }

    @Generated
    public List<String> getPatterns() {
        return this.patterns;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindComments(patterns=" + this.getPatterns() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindComments)) {
            return false;
        }
        FindComments other = (FindComments)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<String> this$patterns = this.getPatterns();
        List<String> other$patterns = other.getPatterns();
        if (this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindComments;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $patterns = this.getPatterns();
        result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

