/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.table.ClasspathTypeCount;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class ClasspathTypeCounts
extends ScanningRecipe<Set<ProjectSourceSet>> {
    private final transient ClasspathTypeCount counts = new ClasspathTypeCount((Recipe)this);
    final String displayName = "Study the size of the classpath by source set";
    final String description = "Emit one data table row per source set in a project, with the number of types in the source set.";

    public Set<ProjectSourceSet> getInitialValue(ExecutionContext ctx) {
        return new LinkedHashSet<ProjectSourceSet>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Set<ProjectSourceSet> acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J preVisit(J tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaProject javaProject = tree.getMarkers().findFirst(JavaProject.class).orElse(null);
                    JavaSourceSet sourceSet = tree.getMarkers().findFirst(JavaSourceSet.class).orElse(null);
                    if (javaProject != null && sourceSet != null) {
                        acc.add(new ProjectSourceSet(javaProject, sourceSet));
                    }
                }
                this.stopAfterPreVisit();
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Set<ProjectSourceSet> acc, ExecutionContext ctx) {
        for (ProjectSourceSet projectSourceSet : acc) {
            this.counts.insertRow(ctx, new ClasspathTypeCount.Row(projectSourceSet.getJavaProject().getProjectName(), projectSourceSet.getSourceSet().getName(), projectSourceSet.getSourceSet().getClasspath().size()));
        }
        return Collections.emptyList();
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    public static final class ProjectSourceSet {
        private final JavaProject javaProject;
        private final JavaSourceSet sourceSet;

        @Generated
        public ProjectSourceSet(JavaProject javaProject, JavaSourceSet sourceSet) {
            this.javaProject = javaProject;
            this.sourceSet = sourceSet;
        }

        @Generated
        public JavaProject getJavaProject() {
            return this.javaProject;
        }

        @Generated
        public JavaSourceSet getSourceSet() {
            return this.sourceSet;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProjectSourceSet)) {
                return false;
            }
            ProjectSourceSet other = (ProjectSourceSet)o;
            JavaProject this$javaProject = this.getJavaProject();
            JavaProject other$javaProject = other.getJavaProject();
            if (this$javaProject == null ? other$javaProject != null : !((Object)this$javaProject).equals(other$javaProject)) {
                return false;
            }
            JavaSourceSet this$sourceSet = this.getSourceSet();
            JavaSourceSet other$sourceSet = other.getSourceSet();
            return !(this$sourceSet == null ? other$sourceSet != null : !((Object)this$sourceSet).equals(other$sourceSet));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JavaProject $javaProject = this.getJavaProject();
            result = result * 59 + ($javaProject == null ? 43 : ((Object)$javaProject).hashCode());
            JavaSourceSet $sourceSet = this.getSourceSet();
            result = result * 59 + ($sourceSet == null ? 43 : ((Object)$sourceSet).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ClasspathTypeCounts.ProjectSourceSet(javaProject=" + this.getJavaProject() + ", sourceSet=" + this.getSourceSet() + ")";
        }
    }
}

