/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;

public class SingleLineComments
extends Recipe {
    final String displayName = "Single line comments begin with a whitespace";
    final String description = "Write `// hi` instead of `//hi`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public Space visitSpace(Space space, Space.Location loc, ExecutionContext ctx) {
                return space.withComments(ListUtils.map(space.getComments(), c -> {
                    TextComment tc;
                    String commentText;
                    if (!(c.isMultiline() || (commentText = (tc = (TextComment)c).getText()).isEmpty() || commentText.startsWith(" "))) {
                        return tc.withText(" " + commentText);
                    }
                    return c;
                }));
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

