/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.lang.reflect.Field;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public final class ReplaceStringLiteralWithConstant
extends Recipe {
    private static final String CONSTANT_FQN_PARAM = "fullyQualifiedConstantName";
    @Option(displayName="String literal value to replace", description="The literal that is to be replaced. If not configured, the value of the specified constant will be used by default.", example="application/json", required=false)
    private @Nullable String literalValue;
    @Option(displayName="Fully qualified name of the constant to use in place of String literal", example="org.springframework.http.MediaType.APPLICATION_JSON_VALUE")
    private final @Nullable String fullyQualifiedConstantName;
    private final String displayName = "Replace String literal with constant";
    private final String description = "Replace String literal with constant, adding import on class if needed.";

    public @Nullable String getLiteralValue() {
        if (this.literalValue == null && this.fullyQualifiedConstantName != null) {
            try {
                this.literalValue = (String)ReplaceStringLiteralWithConstant.getConstantValueByFullyQualifiedName(this.fullyQualifiedConstantName);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                return null;
            }
        }
        return this.literalValue;
    }

    public Validated<Object> validate() {
        Validated result = super.validate();
        if (StringUtils.isBlank((String)this.fullyQualifiedConstantName)) {
            return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"The constant's fully qualified name may not be empty or blank."));
        }
        if (StringUtils.isBlank((String)this.literalValue)) {
            try {
                Object constantValue = ReplaceStringLiteralWithConstant.getConstantValueByFullyQualifiedName(this.fullyQualifiedConstantName);
                if (constantValue == null) {
                    return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"Provided constant should not be null."));
                }
                if (!(constantValue instanceof String)) {
                    return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"Unsupported type of constant provided. Only literals can be replaced."));
                }
                return result;
            }
            catch (ClassNotFoundException e) {
                return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"No class for specified name was found."));
            }
            catch (NoSuchFieldException e) {
                return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"No field with specified name was found."));
            }
            catch (IllegalAccessException e) {
                return result.and((Validated)Validated.invalid((String)CONSTANT_FQN_PARAM, (Object)this.fullyQualifiedConstantName, (String)"Unable to access specified field."));
            }
        }
        return result;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        String value = this.getLiteralValue();
        if (value == null) {
            return TreeVisitor.noop();
        }
        assert (this.fullyQualifiedConstantName != null) : "Validation should have failed if constant name is null";
        return new ReplaceStringLiteralVisitor(value, this.fullyQualifiedConstantName);
    }

    private static @Nullable Object getConstantValueByFullyQualifiedName(String fullyQualifiedConstantName) throws ClassNotFoundException, IllegalAccessException, NoSuchFieldException {
        String owningType = fullyQualifiedConstantName.substring(0, fullyQualifiedConstantName.lastIndexOf(46));
        String constantName = fullyQualifiedConstantName.substring(fullyQualifiedConstantName.lastIndexOf(46) + 1);
        Field constantField = Class.forName(owningType).getField(constantName);
        return constantField.get(null);
    }

    @Generated
    public ReplaceStringLiteralWithConstant(@Nullable String literalValue, @Nullable String fullyQualifiedConstantName) {
        this.literalValue = literalValue;
        this.fullyQualifiedConstantName = fullyQualifiedConstantName;
    }

    @Generated
    public @Nullable String getFullyQualifiedConstantName() {
        return this.fullyQualifiedConstantName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceStringLiteralWithConstant(literalValue=" + this.getLiteralValue() + ", fullyQualifiedConstantName=" + this.getFullyQualifiedConstantName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceStringLiteralWithConstant)) {
            return false;
        }
        ReplaceStringLiteralWithConstant other = (ReplaceStringLiteralWithConstant)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$literalValue = this.getLiteralValue();
        String other$literalValue = other.getLiteralValue();
        if (this$literalValue == null ? other$literalValue != null : !this$literalValue.equals(other$literalValue)) {
            return false;
        }
        String this$fullyQualifiedConstantName = this.getFullyQualifiedConstantName();
        String other$fullyQualifiedConstantName = other.getFullyQualifiedConstantName();
        if (this$fullyQualifiedConstantName == null ? other$fullyQualifiedConstantName != null : !this$fullyQualifiedConstantName.equals(other$fullyQualifiedConstantName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ReplaceStringLiteralWithConstant;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $literalValue = this.getLiteralValue();
        result = result * 59 + ($literalValue == null ? 43 : $literalValue.hashCode());
        String $fullyQualifiedConstantName = this.getFullyQualifiedConstantName();
        result = result * 59 + ($fullyQualifiedConstantName == null ? 43 : $fullyQualifiedConstantName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class ReplaceStringLiteralVisitor
    extends JavaVisitor<ExecutionContext> {
        private final String literalValue;
        private final String owningType;
        private final String template;

        public ReplaceStringLiteralVisitor(String literalValue, String fullyQualifiedConstantName) {
            this.literalValue = literalValue;
            this.owningType = fullyQualifiedConstantName.substring(0, fullyQualifiedConstantName.lastIndexOf(46));
            this.template = fullyQualifiedConstantName.substring(this.owningType.lastIndexOf(46) + 1);
        }

        @Override
        public J visitLiteral(J.Literal literal, ExecutionContext ctx) {
            if (!TypeUtils.isString(literal.getType()) || !Objects.equals(this.literalValue, literal.getValue())) {
                return super.visitLiteral(literal, ctx);
            }
            J.ClassDeclaration classDeclaration = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
            if (classDeclaration != null && classDeclaration.getType() != null && this.owningType.equals(classDeclaration.getType().getFullyQualifiedName())) {
                return super.visitLiteral(literal, ctx);
            }
            this.maybeAddImport(this.owningType, false);
            return JavaTemplate.builder(this.template).imports(this.owningType).build().apply(this.getCursor(), literal.getCoordinates().replace(), new Object[0]).withPrefix(literal.getPrefix());
        }
    }
}

