/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.service.ImportService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class ReplaceAnnotation
extends Recipe {
    @Option(displayName="Annotation to replace", description="An annotation matcher, expressed as a method pattern to replace.", example="@org.jetbrains.annotations.NotNull(\"Test\")")
    private final String annotationPatternToReplace;
    @Option(displayName="Annotation template to insert", description="An annotation template to add instead of original one, will be parsed with `JavaTemplate`.", example="@org.jetbrains.annotations.NotNull(\"Null not permitted\")")
    private final String annotationTemplateToInsert;
    @Option(displayName="Classpath resource", description="If the annotation's type is defined by a jar within the META-INF/rewrite/classpath directory provide its name here so that it can be loaded. When this parameter is not passed the runtime classpath of the recipe is provided to the parser producing the new annotation. This is necessary when the annotation is not on the runtime classpath of the recipe and isn't in the Java standard library.", example="annotations", required=false)
    private final @Nullable String classpathResourceName;
    private final String displayName = "Replace annotation";
    private final String description = "Replace an Annotation with another one if the annotation pattern matches. Only fixed parameters can be set in the replacement.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final AnnotationMatcher matcher = new AnnotationMatcher(this.annotationPatternToReplace);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J a = super.visitAnnotation(annotation, ctx);
                if (!matcher.matches((J.Annotation)a)) {
                    return a;
                }
                this.maybeRemoveImport(TypeUtils.asFullyQualified(((J.Annotation)a).getType()));
                this.collectTypesFromArguments((J.Annotation)a).forEach(this::maybeRemoveImport);
                a = (J.Annotation)JavaTemplate.builder(ReplaceAnnotation.this.annotationTemplateToInsert).javaParser((JavaParser.Builder<?, ?>)((Object)(ReplaceAnnotation.this.classpathResourceName == null ? JavaParser.fromJavaVersion().classpath(JavaParser.runtimeClasspath()) : JavaParser.fromJavaVersion().classpathFromResources(ctx, ReplaceAnnotation.this.classpathResourceName)))).build().apply(this.getCursor(), ((J.Annotation)a).getCoordinates().replace(), new Object[0]);
                this.doAfterVisit(this.service(ImportService.class).shortenFullyQualifiedTypeReferencesIn(a));
                return a;
            }

            private Collection<JavaType.FullyQualified> collectTypesFromArguments(J.Annotation a) {
                if (a.getArguments() == null || a.getArguments().isEmpty() || a.getArguments().get(0) instanceof J.Empty) {
                    return Collections.emptySet();
                }
                HashSet<JavaType.FullyQualified> typesToRemove = new HashSet<JavaType.FullyQualified>();
                for (Expression arg : a.getArguments()) {
                    this.collectTypesFromExpression(arg, typesToRemove);
                }
                return typesToRemove;
            }

            private void collectTypesFromExpression(Expression expr, Set<JavaType.FullyQualified> types) {
                JavaType.Class classType;
                JavaType.FullyQualified fq;
                J.Identifier identifier;
                JavaType type;
                if (expr instanceof J.FieldAccess) {
                    Expression target;
                    JavaType targetType;
                    J.FieldAccess fieldAccess = (J.FieldAccess)expr;
                    if ("class".equals(fieldAccess.getSimpleName()) && (targetType = (target = fieldAccess.getTarget()).getType()) instanceof JavaType.FullyQualified) {
                        types.add((JavaType.FullyQualified)targetType);
                    }
                    this.collectTypesFromExpression(fieldAccess.getTarget(), types);
                } else if (expr instanceof J.NewArray) {
                    J.NewArray newArray = (J.NewArray)expr;
                    if (newArray.getInitializer() != null) {
                        for (Expression element : newArray.getInitializer()) {
                            this.collectTypesFromExpression(element, types);
                        }
                    }
                } else if (expr instanceof J.Assignment) {
                    J.Assignment assignment = (J.Assignment)expr;
                    this.collectTypesFromExpression(assignment.getAssignment(), types);
                } else if (expr instanceof J.Identifier && (type = (identifier = (J.Identifier)expr).getType()) instanceof JavaType.Class && (fq = TypeUtils.asFullyQualified(classType = (JavaType.Class)type)) != null && !fq.getFullyQualifiedName().startsWith("java.lang.Class")) {
                    types.add(fq);
                }
            }
        };
    }

    @Generated
    public ReplaceAnnotation(String annotationPatternToReplace, String annotationTemplateToInsert, @Nullable String classpathResourceName) {
        this.annotationPatternToReplace = annotationPatternToReplace;
        this.annotationTemplateToInsert = annotationTemplateToInsert;
        this.classpathResourceName = classpathResourceName;
    }

    @Generated
    public String getAnnotationPatternToReplace() {
        return this.annotationPatternToReplace;
    }

    @Generated
    public String getAnnotationTemplateToInsert() {
        return this.annotationTemplateToInsert;
    }

    @Generated
    public @Nullable String getClasspathResourceName() {
        return this.classpathResourceName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceAnnotation(annotationPatternToReplace=" + this.getAnnotationPatternToReplace() + ", annotationTemplateToInsert=" + this.getAnnotationTemplateToInsert() + ", classpathResourceName=" + this.getClasspathResourceName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceAnnotation)) {
            return false;
        }
        ReplaceAnnotation other = (ReplaceAnnotation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$annotationPatternToReplace = this.getAnnotationPatternToReplace();
        String other$annotationPatternToReplace = other.getAnnotationPatternToReplace();
        if (this$annotationPatternToReplace == null ? other$annotationPatternToReplace != null : !this$annotationPatternToReplace.equals(other$annotationPatternToReplace)) {
            return false;
        }
        String this$annotationTemplateToInsert = this.getAnnotationTemplateToInsert();
        String other$annotationTemplateToInsert = other.getAnnotationTemplateToInsert();
        if (this$annotationTemplateToInsert == null ? other$annotationTemplateToInsert != null : !this$annotationTemplateToInsert.equals(other$annotationTemplateToInsert)) {
            return false;
        }
        String this$classpathResourceName = this.getClasspathResourceName();
        String other$classpathResourceName = other.getClasspathResourceName();
        if (this$classpathResourceName == null ? other$classpathResourceName != null : !this$classpathResourceName.equals(other$classpathResourceName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ReplaceAnnotation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $annotationPatternToReplace = this.getAnnotationPatternToReplace();
        result = result * 59 + ($annotationPatternToReplace == null ? 43 : $annotationPatternToReplace.hashCode());
        String $annotationTemplateToInsert = this.getAnnotationTemplateToInsert();
        result = result * 59 + ($annotationTemplateToInsert == null ? 43 : $annotationTemplateToInsert.hashCode());
        String $classpathResourceName = this.getClasspathResourceName();
        result = result * 59 + ($classpathResourceName == null ? 43 : $classpathResourceName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

