/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.SimplifySingleElementAnnotation;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class AddOrUpdateAnnotationAttribute
extends Recipe {
    private final String displayName = "Add or update annotation attribute";
    private final String description = "Some annotations accept arguments. This recipe sets an existing argument to the specified value, or adds the argument if it is not already set.";
    @Option(displayName="Annotation type", description="The fully qualified name of the annotation.", example="org.junit.Test")
    private final String annotationType;
    @Option(displayName="Attribute name", description="The name of attribute to change. If omitted defaults to 'value'.", required=false, example="timeout")
    private final @Nullable String attributeName;
    @Option(displayName="Attribute value", description="The value to set the attribute to. If the attribute is an array, provide values separated by comma to add multiple attributes at once. Set to `null` to remove the attribute.", required=false, example="500")
    private final @Nullable String attributeValue;
    @Option(displayName="Old Attribute value", description="The current value of the attribute, this can be used to filter where the change is applied. Set to `null` for wildcard behavior.", required=false, example="400")
    private final @Nullable String oldAttributeValue;
    @Option(displayName="Add only", description="If `true`, disables upgrading existing annotation attribute values, thus the recipe will only add the attribute if it does not already exist. If omitted or `false`, the recipe adds the attribute if missing or updates its value if present.", required=false)
    private final @Nullable Boolean addOnly;
    @Option(displayName="Append array", description="If the attribute is an array and attribute is present, setting this option to `true` will append the value(s). Duplicate values will not be added. If omitted or `false`, the recipe will replace the existing value(s) with the new value(s).", required=false)
    private final @Nullable Boolean appendArray;

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesType(this.annotationType, false), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation original, ExecutionContext ctx) {
                String newAttributeValue;
                J a = super.visitAnnotation(original, ctx);
                if (!TypeUtils.isOfClassType(((J.Annotation)a).getType(), AddOrUpdateAnnotationAttribute.this.annotationType) || !(((J.Annotation)a).getType() instanceof JavaType.ShallowClass) && !AddOrUpdateAnnotationAttribute.findMethod((J.Annotation)a, AddOrUpdateAnnotationAttribute.this.attributeName()).isPresent()) {
                    return a;
                }
                if (AddOrUpdateAnnotationAttribute.this.attributeValue != null && AddOrUpdateAnnotationAttribute.this.attributeValue.endsWith(".class") && StringUtils.countOccurrences((String)AddOrUpdateAnnotationAttribute.this.attributeValue, (String)".") > 1) {
                    this.maybeAddImport(AddOrUpdateAnnotationAttribute.this.attributeValue.substring(0, AddOrUpdateAnnotationAttribute.this.attributeValue.length() - 6));
                    newAttributeValue = AddOrUpdateAnnotationAttribute.this.attributeValue;
                } else {
                    newAttributeValue = AddOrUpdateAnnotationAttribute.this.maybeQuoteStringArgument((J.Annotation)a, AddOrUpdateAnnotationAttribute.this.attributeValue);
                }
                List<Expression> currentArgs = ((J.Annotation)a).getArguments();
                if (currentArgs == null || currentArgs.isEmpty() || currentArgs.get(0) instanceof J.Empty) {
                    if (newAttributeValue == null || AddOrUpdateAnnotationAttribute.this.oldAttributeValue != null) {
                        return a;
                    }
                    if ("value".equals(AddOrUpdateAnnotationAttribute.this.attributeName())) {
                        return (J.Annotation)JavaTemplate.apply("#{}", this.getCursor(), ((J.Annotation)a).getCoordinates().replaceArguments(), newAttributeValue);
                    }
                    String attrVal = newAttributeValue.contains(",") && AddOrUpdateAnnotationAttribute.this.attributeIsArray((J.Annotation)a) ? AddOrUpdateAnnotationAttribute.this.getAttributeValuesAsString() : newAttributeValue;
                    return (J.Annotation)JavaTemplate.apply("#{} = #{}", this.getCursor(), ((J.Annotation)a).getCoordinates().replaceArguments(), AddOrUpdateAnnotationAttribute.this.attributeName, attrVal);
                }
                if (!Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                    J finalA = a;
                    a = ((J.Annotation)a).withArguments(ListUtils.map(currentArgs, arg_0 -> this.lambda$visitAnnotation$0((J.Annotation)finalA, newAttributeValue, arg_0)));
                }
                if (AddOrUpdateAnnotationAttribute.this.oldAttributeValue == null && newAttributeValue != null && !AddOrUpdateAnnotationAttribute.this.attributeNameOrValIsAlreadyPresent(((J.Annotation)a).getArguments(), AddOrUpdateAnnotationAttribute.this.getAttributeValues())) {
                    J.Assignment as = this.createAnnotationAssignment((J.Annotation)a, AddOrUpdateAnnotationAttribute.this.attributeName(), newAttributeValue);
                    List<Expression> args = ((J.Annotation)a).getArguments();
                    if (args.size() == 1 && !(args.get(0) instanceof J.Assignment)) {
                        args = Collections.singletonList(this.createAnnotationAssignment((J.Annotation)a, "value", ((J.Annotation)a).getArguments().get(0)));
                    }
                    a = ((J.Annotation)a).withArguments(ListUtils.concat((Object)as, args));
                }
                if (original != a) {
                    this.doAfterVisit(new SimplifySingleElementAnnotation().getVisitor());
                }
                return (J.Annotation)this.maybeAutoFormat(original, a, ctx);
            }

            private @Nullable Expression update(J.Assignment as, J.Annotation annotation, @Nullable String newAttributeValue) {
                J.Identifier var_ = (J.Identifier)as.getVariable();
                if (AddOrUpdateAnnotationAttribute.this.attributeName == null && !"value".equals(var_.getSimpleName()) || AddOrUpdateAnnotationAttribute.this.attributeName != null && !AddOrUpdateAnnotationAttribute.this.attributeName.equals(var_.getSimpleName())) {
                    return as;
                }
                if (newAttributeValue == null) {
                    return null;
                }
                Expression exp = as.getAssignment();
                if (exp instanceof J.NewArray) {
                    List<Expression> initializerList = Objects.requireNonNull(((J.NewArray)exp).getInitializer());
                    return as.withAssignment(((J.NewArray)exp).withInitializer(AddOrUpdateAnnotationAttribute.this.updateInitializer(annotation, initializerList, AddOrUpdateAnnotationAttribute.this.getAttributeValues())));
                }
                if (exp instanceof J.Literal) {
                    if (!AddOrUpdateAnnotationAttribute.valueMatches(exp, AddOrUpdateAnnotationAttribute.this.oldAttributeValue) || newAttributeValue.equals(((J.Literal)exp).getValueSource())) {
                        return as;
                    }
                    return as.withAssignment(this.createAnnotationLiteral(annotation, newAttributeValue));
                }
                if (exp instanceof J.FieldAccess) {
                    if (AddOrUpdateAnnotationAttribute.this.oldAttributeValue != null) {
                        return as;
                    }
                    if (AddOrUpdateAnnotationAttribute.this.isFullyQualifiedClass() && AddOrUpdateAnnotationAttribute.getFullyQualifiedClass(newAttributeValue).equals(exp.toString())) {
                        return as;
                    }
                    return ((J.Annotation)JavaTemplate.apply("#{} = #{}", this.getCursor(), as.getCoordinates().replace(), var_.getSimpleName(), newAttributeValue)).getArguments().get(annotation.getArguments().indexOf(as));
                }
                return as;
            }

            private @Nullable Expression update(J.Literal literal, J.Annotation annotation, @Nullable String newAttributeValue) {
                if ("value".equals(AddOrUpdateAnnotationAttribute.this.attributeName())) {
                    if (newAttributeValue == null) {
                        return null;
                    }
                    if (!AddOrUpdateAnnotationAttribute.valueMatches(literal, AddOrUpdateAnnotationAttribute.this.oldAttributeValue) || newAttributeValue.equals(literal.getValueSource())) {
                        return literal;
                    }
                    return this.createAnnotationLiteral(annotation, newAttributeValue);
                }
                if (AddOrUpdateAnnotationAttribute.this.oldAttributeValue == null && newAttributeValue != null) {
                    return this.createAnnotationAssignment(annotation, "value", literal);
                }
                return literal;
            }

            private @Nullable Expression update(J.FieldAccess fieldAccess, J.Annotation annotation, @Nullable String newAttributeValue) {
                if ("value".equals(AddOrUpdateAnnotationAttribute.this.attributeName())) {
                    if (newAttributeValue == null) {
                        return null;
                    }
                    if (AddOrUpdateAnnotationAttribute.this.isFullyQualifiedClass() && AddOrUpdateAnnotationAttribute.getFullyQualifiedClass(newAttributeValue).equals(fieldAccess.toString())) {
                        return fieldAccess;
                    }
                    if (!AddOrUpdateAnnotationAttribute.valueMatches(fieldAccess, AddOrUpdateAnnotationAttribute.this.oldAttributeValue) || newAttributeValue.equals(fieldAccess.toString())) {
                        return fieldAccess;
                    }
                    String attrVal = newAttributeValue.contains(",") && AddOrUpdateAnnotationAttribute.this.attributeIsArray(annotation) ? AddOrUpdateAnnotationAttribute.this.getAttributeValues().stream().map(String::valueOf).collect(Collectors.joining(",", "{", "}")) : newAttributeValue;
                    return ((J.Annotation)JavaTemplate.apply("#{}", this.getCursor(), annotation.getCoordinates().replaceArguments(), attrVal)).getArguments().get(0);
                }
                return this.createAnnotationAssignment(annotation, "value", fieldAccess);
            }

            private @Nullable Expression update(J.NewArray arrayValue, J.Annotation annotation, @Nullable String newAttributeValue) {
                if (newAttributeValue == null) {
                    return null;
                }
                if (AddOrUpdateAnnotationAttribute.this.attributeName != null && !"value".equals(AddOrUpdateAnnotationAttribute.this.attributeValue)) {
                    return AddOrUpdateAnnotationAttribute.isAnnotationWithOnlyValueMethod(annotation) ? arrayValue : this.createAnnotationAssignment(annotation, "value", arrayValue);
                }
                return arrayValue.withInitializer(AddOrUpdateAnnotationAttribute.this.updateInitializer(annotation, Objects.requireNonNull(arrayValue.getInitializer()), AddOrUpdateAnnotationAttribute.this.getAttributeValues()));
            }

            private Expression createAnnotationLiteral(J.Annotation annotation, String newAttributeValue) {
                String attrVal = newAttributeValue.contains(",") && AddOrUpdateAnnotationAttribute.this.attributeIsArray(annotation) ? AddOrUpdateAnnotationAttribute.this.getAttributeValuesAsString() : newAttributeValue;
                return ((J.Annotation)JavaTemplate.apply("#{}", this.getCursor(), annotation.getCoordinates().replaceArguments(), attrVal)).getArguments().get(0);
            }

            private J.Assignment createAnnotationAssignment(J.Annotation annotation, String name, @Nullable Object parameter) {
                return (J.Assignment)((J.Annotation)JavaTemplate.apply(name + " = " + (parameter instanceof J ? "#{any()}" : "#{}"), this.getCursor(), annotation.getCoordinates().replaceArguments(), parameter)).getArguments().get(0);
            }

            private /* synthetic */ Expression lambda$visitAnnotation$0(J.Annotation finalA, String newAttributeValue, Expression it) {
                if (it instanceof J.Assignment) {
                    return this.update((J.Assignment)it, finalA, newAttributeValue);
                }
                if (it instanceof J.Literal) {
                    return this.update((J.Literal)it, finalA, newAttributeValue);
                }
                if (it instanceof J.FieldAccess) {
                    return this.update((J.FieldAccess)it, finalA, newAttributeValue);
                }
                if (it instanceof J.NewArray) {
                    return this.update((J.NewArray)it, finalA, newAttributeValue);
                }
                return it;
            }
        });
    }

    private boolean isFullyQualifiedClass() {
        return this.attributeValue != null && this.attributeValue.endsWith(".class") && StringUtils.countOccurrences((String)this.attributeValue, (String)".") > 1;
    }

    private static String getFullyQualifiedClass(String fqn) {
        String withoutClassSuffix = fqn.substring(0, fqn.length() - 6);
        return withoutClassSuffix.substring(withoutClassSuffix.lastIndexOf(46) + 1) + ".class";
    }

    private String attributeName() {
        return this.attributeName == null ? "value" : this.attributeName;
    }

    private List<Expression> updateInitializer(J.Annotation annotation, List<Expression> initializerList, List<String> attributeList) {
        if (this.oldAttributeValue != null) {
            return ListUtils.flatMap(initializerList, it -> {
                if (it instanceof J.Literal && this.oldAttributeValue.equals(((J.Literal)it).getValue())) {
                    ArrayList<J.Literal> newItemsList = new ArrayList<J.Literal>();
                    for (String attribute : attributeList) {
                        J.Literal newLiteral = new J.Literal(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, attribute, this.maybeQuoteStringArgument(annotation, attribute), null, JavaType.Primitive.String);
                        newItemsList.add(newLiteral);
                    }
                    return newItemsList;
                }
                return it;
            });
        }
        if (Boolean.TRUE.equals(this.appendArray)) {
            ArrayList<J.Literal> newItemsList = new ArrayList<J.Literal>();
            for (String attribute : attributeList) {
                if (this.attributeNameOrValIsAlreadyPresent(initializerList, Collections.singleton(attribute))) continue;
                newItemsList.add(new J.Literal(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, attribute, this.maybeQuoteStringArgument(annotation, attribute), null, JavaType.Primitive.String));
            }
            return ListUtils.concatAll(initializerList, newItemsList);
        }
        List list = ListUtils.map(initializerList, (i, it) -> {
            if (i >= attributeList.size()) {
                return null;
            }
            if (this.attributeNameOrValIsAlreadyPresent((Expression)it, (Collection<?>)Collections.singleton((String)attributeList.get((int)i)))) {
                return it;
            }
            return new J.Literal(Tree.randomId(), it.getPrefix(), Markers.EMPTY, attributeList.get((int)i), this.maybeQuoteStringArgument(annotation, (String)attributeList.get((int)i)), null, JavaType.Primitive.String);
        });
        for (int i2 = initializerList.size(); i2 < attributeList.size(); ++i2) {
            list.add(new J.Literal(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, attributeList.get(i2), this.maybeQuoteStringArgument(annotation, attributeList.get(i2)), null, JavaType.Primitive.String));
        }
        return list;
    }

    private List<String> getAttributeValues() {
        String[] stringArray;
        if (this.attributeValue == null) {
            return Collections.emptyList();
        }
        if (this.isFullyQualifiedClass()) {
            return Collections.singletonList(AddOrUpdateAnnotationAttribute.getFullyQualifiedClass(this.attributeValue));
        }
        String attributeValueCleanedUp = this.attributeValue.replaceAll("\\s+", "").replaceAll("[\\s+{}\"]", "");
        if (attributeValueCleanedUp.contains(",")) {
            stringArray = attributeValueCleanedUp.split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = attributeValueCleanedUp;
        }
        return Arrays.asList(stringArray);
    }

    private String getAttributeValuesAsString() {
        return this.getAttributeValues().stream().map(String::valueOf).collect(Collectors.joining("\", \"", "{\"", "\"}"));
    }

    private static boolean isAnnotationWithOnlyValueMethod(J.Annotation annotation) {
        return AddOrUpdateAnnotationAttribute.getMethods(annotation).size() == 1 && "value".equals(AddOrUpdateAnnotationAttribute.getMethods(annotation).get(0).getName());
    }

    private static boolean valueMatches(@Nullable Expression expression, @Nullable String oldAttributeValue) {
        if (expression == null) {
            return oldAttributeValue == null;
        }
        if (oldAttributeValue == null) {
            return true;
        }
        if (expression instanceof J.Literal) {
            return oldAttributeValue.equals(((J.Literal)expression).getValue());
        }
        if (expression instanceof J.FieldAccess) {
            J.FieldAccess fa = (J.FieldAccess)expression;
            if (!(fa.getTarget() instanceof J.Identifier)) {
                return oldAttributeValue.equals(fa.toString());
            }
            String currentValue = ((J.Identifier)fa.getTarget()).getSimpleName() + "." + fa.getSimpleName();
            return oldAttributeValue.equals(currentValue);
        }
        if (expression instanceof J.Identifier) {
            if (oldAttributeValue.endsWith(".class")) {
                String className = TypeUtils.toString(Objects.requireNonNull(expression.getType())) + ".class";
                return className.endsWith(oldAttributeValue);
            }
            return oldAttributeValue.equals(((J.Identifier)expression).getSimpleName());
        }
        throw new IllegalArgumentException("Unexpected expression type: " + expression.getClass());
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    private @Nullable String maybeQuoteStringArgument(J.Annotation annotation, @Nullable String attributeValue) {
        if (attributeValue != null && this.attributeIsString(annotation)) {
            return "\"" + attributeValue + "\"";
        }
        return attributeValue;
    }

    private boolean attributeIsArray(J.Annotation annotation) {
        return AddOrUpdateAnnotationAttribute.findMethod(annotation, this.attributeName()).map(it -> it.getReturnType() instanceof JavaType.Array).orElse(false);
    }

    private boolean attributeIsString(J.Annotation annotation) {
        return AddOrUpdateAnnotationAttribute.findMethod(annotation, this.attributeName()).map(it -> TypeUtils.isOfClassType(it.getReturnType(), "java.lang.String")).orElse(false);
    }

    private static Optional<JavaType.Method> findMethod(J.Annotation annotation, String methodName) {
        for (JavaType.Method it : AddOrUpdateAnnotationAttribute.getMethods(annotation)) {
            if (!methodName.equals(it.getName())) continue;
            return Optional.of(it);
        }
        return Optional.empty();
    }

    private static List<JavaType.Method> getMethods(J.Annotation annotation) {
        return ((JavaType.FullyQualified)Objects.requireNonNull(annotation.getAnnotationType().getType())).getMethods();
    }

    private boolean attributeNameOrValIsAlreadyPresent(Collection<Expression> expression, Collection<?> values) {
        for (Expression e : expression) {
            if (!this.attributeNameOrValIsAlreadyPresent(e, values)) continue;
            return true;
        }
        return false;
    }

    private boolean attributeNameOrValIsAlreadyPresent(Expression e, Collection<?> values) {
        if (e instanceof J.Assignment) {
            J.Assignment as = (J.Assignment)e;
            if (as.getVariable() instanceof J.Identifier) {
                return ((J.Identifier)as.getVariable()).getSimpleName().equals(this.attributeName());
            }
        } else {
            if (e instanceof J.Literal) {
                return values.contains(((J.Literal)e).getValue() + "");
            }
            if (e instanceof J.FieldAccess) {
                return values.contains(e.toString());
            }
            if (e instanceof J.NewArray) {
                List<Expression> initializer = ((J.NewArray)e).getInitializer();
                return initializer == null && this.attributeValue == null || initializer != null && this.attributeNameOrValIsAlreadyPresent(initializer, values);
            }
        }
        return false;
    }

    @Generated
    public AddOrUpdateAnnotationAttribute(String annotationType, @Nullable String attributeName, @Nullable String attributeValue, @Nullable String oldAttributeValue, @Nullable Boolean addOnly, @Nullable Boolean appendArray) {
        this.annotationType = annotationType;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.oldAttributeValue = oldAttributeValue;
        this.addOnly = addOnly;
        this.appendArray = appendArray;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getAnnotationType() {
        return this.annotationType;
    }

    @Generated
    public @Nullable String getAttributeName() {
        return this.attributeName;
    }

    @Generated
    public @Nullable String getAttributeValue() {
        return this.attributeValue;
    }

    @Generated
    public @Nullable String getOldAttributeValue() {
        return this.oldAttributeValue;
    }

    @Generated
    public @Nullable Boolean getAddOnly() {
        return this.addOnly;
    }

    @Generated
    public @Nullable Boolean getAppendArray() {
        return this.appendArray;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddOrUpdateAnnotationAttribute(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", annotationType=" + this.getAnnotationType() + ", attributeName=" + this.getAttributeName() + ", attributeValue=" + this.getAttributeValue() + ", oldAttributeValue=" + this.getOldAttributeValue() + ", addOnly=" + this.getAddOnly() + ", appendArray=" + this.getAppendArray() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddOrUpdateAnnotationAttribute)) {
            return false;
        }
        AddOrUpdateAnnotationAttribute other = (AddOrUpdateAnnotationAttribute)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addOnly = this.getAddOnly();
        Boolean other$addOnly = other.getAddOnly();
        if (this$addOnly == null ? other$addOnly != null : !((Object)this$addOnly).equals(other$addOnly)) {
            return false;
        }
        Boolean this$appendArray = this.getAppendArray();
        Boolean other$appendArray = other.getAppendArray();
        if (this$appendArray == null ? other$appendArray != null : !((Object)this$appendArray).equals(other$appendArray)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$annotationType = this.getAnnotationType();
        String other$annotationType = other.getAnnotationType();
        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$attributeValue = this.getAttributeValue();
        String other$attributeValue = other.getAttributeValue();
        if (this$attributeValue == null ? other$attributeValue != null : !this$attributeValue.equals(other$attributeValue)) {
            return false;
        }
        String this$oldAttributeValue = this.getOldAttributeValue();
        String other$oldAttributeValue = other.getOldAttributeValue();
        return !(this$oldAttributeValue == null ? other$oldAttributeValue != null : !this$oldAttributeValue.equals(other$oldAttributeValue));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddOrUpdateAnnotationAttribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addOnly = this.getAddOnly();
        result = result * 59 + ($addOnly == null ? 43 : ((Object)$addOnly).hashCode());
        Boolean $appendArray = this.getAppendArray();
        result = result * 59 + ($appendArray == null ? 43 : ((Object)$appendArray).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $annotationType = this.getAnnotationType();
        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $attributeValue = this.getAttributeValue();
        result = result * 59 + ($attributeValue == null ? 43 : $attributeValue.hashCode());
        String $oldAttributeValue = this.getOldAttributeValue();
        result = result * 59 + ($oldAttributeValue == null ? 43 : $oldAttributeValue.hashCode());
        return result;
    }
}

