/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

public final class AddNullMethodArgument
extends Recipe {
    @Option(displayName="Method pattern", description="A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method invocations. For example, to find all method invocations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.", example="com.yourorg.A foo(int, int)")
    private final String methodPattern;
    @Option(displayName="Argument index", description="A zero-based index that indicates which argument will be added as null to the method invocation.", example="0")
    private final int argumentIndex;
    @Option(displayName="Parameter type", description="The type of the parameter that we add the argument for.", example="java.lang.String")
    private final String parameterType;
    @Option(displayName="Parameter name", description="The name of the parameter that we add the argument for.", required=false, example="name")
    private final @Nullable String parameterName;
    @Option(displayName="Explicit cast", description="Explicitly cast the argument to the parameter type. Useful if the method is overridden with another type.", required=false, example="true")
    private final @Nullable Boolean explicitCast;
    private final String displayName = "Add a `null` method argument";
    private final String description = "Add a `null` argument to method invocations.";

    public String getInstanceNameSuffix() {
        return String.format("%d in methods `%s`", this.argumentIndex, this.methodPattern);
    }

    public Validated<Object> validate() {
        return super.validate().and(MethodMatcher.validate(this.methodPattern));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesMethod(this.methodPattern), (TreeVisitor)new AddNullMethodArgumentVisitor(new MethodMatcher(this.methodPattern)));
    }

    @Generated
    public AddNullMethodArgument(String methodPattern, int argumentIndex, String parameterType, @Nullable String parameterName, @Nullable Boolean explicitCast) {
        this.methodPattern = methodPattern;
        this.argumentIndex = argumentIndex;
        this.parameterType = parameterType;
        this.parameterName = parameterName;
        this.explicitCast = explicitCast;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public int getArgumentIndex() {
        return this.argumentIndex;
    }

    @Generated
    public String getParameterType() {
        return this.parameterType;
    }

    @Generated
    public @Nullable String getParameterName() {
        return this.parameterName;
    }

    @Generated
    public @Nullable Boolean getExplicitCast() {
        return this.explicitCast;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddNullMethodArgument(methodPattern=" + this.getMethodPattern() + ", argumentIndex=" + this.getArgumentIndex() + ", parameterType=" + this.getParameterType() + ", parameterName=" + this.getParameterName() + ", explicitCast=" + this.getExplicitCast() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddNullMethodArgument)) {
            return false;
        }
        AddNullMethodArgument other = (AddNullMethodArgument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getArgumentIndex() != other.getArgumentIndex()) {
            return false;
        }
        Boolean this$explicitCast = this.getExplicitCast();
        Boolean other$explicitCast = other.getExplicitCast();
        if (this$explicitCast == null ? other$explicitCast != null : !((Object)this$explicitCast).equals(other$explicitCast)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$parameterType = this.getParameterType();
        String other$parameterType = other.getParameterType();
        if (this$parameterType == null ? other$parameterType != null : !this$parameterType.equals(other$parameterType)) {
            return false;
        }
        String this$parameterName = this.getParameterName();
        String other$parameterName = other.getParameterName();
        if (this$parameterName == null ? other$parameterName != null : !this$parameterName.equals(other$parameterName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddNullMethodArgument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getArgumentIndex();
        Boolean $explicitCast = this.getExplicitCast();
        result = result * 59 + ($explicitCast == null ? 43 : ((Object)$explicitCast).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $parameterType = this.getParameterType();
        result = result * 59 + ($parameterType == null ? 43 : $parameterType.hashCode());
        String $parameterName = this.getParameterName();
        result = result * 59 + ($parameterName == null ? 43 : $parameterName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private class AddNullMethodArgumentVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        public AddNullMethodArgumentVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            return (J.MethodInvocation)this.visitMethodCall((MethodCall)m);
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J n = super.visitNewClass(newClass, ctx);
            return (J.NewClass)this.visitMethodCall((MethodCall)n);
        }

        private MethodCall visitMethodCall(MethodCall methodCall) {
            MethodCall m = methodCall;
            List<Expression> originalArgs = m.getArguments();
            if (this.methodMatcher.matches(m) && (long)originalArgs.size() >= (long)AddNullMethodArgument.this.argumentIndex) {
                JavaType.Method methodType;
                ArrayList<Expression> args = new ArrayList<Expression>(originalArgs);
                if (args.size() == 1 && args.get(0) instanceof J.Empty) {
                    args.remove(0);
                }
                TypedTree nullLiteral = new J.Literal(Tree.randomId(), args.isEmpty() ? Space.EMPTY : Space.SINGLE_SPACE, Markers.EMPTY, "null", "null", null, JavaType.Primitive.Null);
                if (AddNullMethodArgument.this.explicitCast == Boolean.TRUE) {
                    nullLiteral = new J.TypeCast(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, new J.ControlParentheses<TypeTree>(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded(TypeTree.build(AddNullMethodArgument.this.parameterType), Space.EMPTY, Markers.EMPTY)), (Expression)((Object)nullLiteral));
                }
                if ((methodType = (m = m.withArguments(ListUtils.insert(args, (Object)nullLiteral, (int)AddNullMethodArgument.this.argumentIndex))).getMethodType()) != null && (m = m.withMethodType(methodType.withParameterNames(ListUtils.insert(methodType.getParameterNames(), (Object)(AddNullMethodArgument.this.parameterName == null ? "arg" + AddNullMethodArgument.this.argumentIndex : AddNullMethodArgument.this.parameterName), (int)AddNullMethodArgument.this.argumentIndex)).withParameterTypes(ListUtils.insert(methodType.getParameterTypes(), (Object)JavaType.buildType(AddNullMethodArgument.this.parameterType), (int)AddNullMethodArgument.this.argumentIndex)))) instanceof J.MethodInvocation && ((J.MethodInvocation)m).getName().getType() != null) {
                    m = ((J.MethodInvocation)m).withName(((J.MethodInvocation)m).getName().withType(m.getMethodType()));
                }
            }
            return m;
        }
    }
}

