/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl.format;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.style.BracketsStyle;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Expression;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.hcl.tree.HclContainer;
import org.openrewrite.hcl.tree.Space;
import org.openrewrite.internal.ListUtils;

public class BracketsVisitor<P>
extends HclIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final BracketsStyle style;

    public BracketsVisitor(BracketsStyle style) {
        this(style, null);
    }

    public BracketsVisitor(BracketsStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @Override
    public Space visitSpace(Space space, Space.Location loc, P p) {
        if (loc == Space.Location.BLOCK_CLOSE && !space.getLastWhitespace().contains("\n")) {
            return space.withLastWhitespace("\n");
        }
        if (loc == Space.Location.BLOCK_OPEN && !" ".equals(space.getWhitespace())) {
            return space.withWhitespace(" ");
        }
        return space;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T extends Hcl> HclContainer<T> visitContainer(HclContainer<T> container, HclContainer.Location loc, P p) {
        if (loc == HclContainer.Location.OBJECT_VALUE_ATTRIBUTES) {
            Hcl.ObjectValue ov = (Hcl.ObjectValue)this.getCursor().firstEnclosingOrThrow(Hcl.ObjectValue.class);
            Space lastSpace = container.getLastSpace();
            if (!this.isMultiline(ov)) return container.withLastSpace(lastSpace.withLastWhitespace(" "));
            if (lastSpace.getLastWhitespace().contains("\n")) return super.visitContainer(container, loc, p);
            return container.withLastSpace(lastSpace.withLastWhitespace("\n"));
        }
        if (loc != HclContainer.Location.TUPLE_VALUES) return super.visitContainer(container, loc, p);
        Hcl.Tuple tuple = (Hcl.Tuple)this.getCursor().firstEnclosingOrThrow(Hcl.Tuple.class);
        Space lastSpace = container.getLastSpace();
        if (!this.isMultiline(tuple) || lastSpace.getLastWhitespace().contains("\n")) return super.visitContainer(container, loc, p);
        return container.withLastSpace(lastSpace.withLastWhitespace("\n"));
    }

    @Override
    public Hcl.ObjectValue visitObjectValue(Hcl.ObjectValue ov, P p) {
        boolean multiLine = this.isMultiline(ov);
        if (multiLine) {
            List newAttributes = ListUtils.map(ov.getAttributes(), (i, attr) -> {
                if (!attr.getPrefix().getLastWhitespace().contains("\n")) {
                    return (Expression)attr.withPrefix(attr.getPrefix().withLastWhitespace("\n"));
                }
                return attr;
            });
            return super.visitObjectValue(ov.withArguments(newAttributes), (Object)p);
        }
        List newAttributes = ListUtils.map(ov.getAttributes(), (i, attr) -> (Expression)attr.withPrefix(attr.getPrefix().withWhitespace(" ")));
        return super.visitObjectValue(ov.withArguments(newAttributes), (Object)p);
    }

    private boolean isMultiline(Hcl.ObjectValue ov) {
        boolean multiLine = false;
        for (Expression attribute : ov.getAttributes()) {
            if (!attribute.getPrefix().getLastWhitespace().contains("\n")) continue;
            multiLine = true;
        }
        return multiLine;
    }

    @Override
    public Hcl.Tuple visitTuple(Hcl.Tuple tuple, P p) {
        boolean multiLine = this.isMultiline(tuple);
        if (multiLine) {
            List newValues = ListUtils.map(tuple.getValues(), (i, value) -> {
                if (!value.getPrefix().getLastWhitespace().contains("\n")) {
                    return (Expression)value.withPrefix(value.getPrefix().withLastWhitespace("\n"));
                }
                return value;
            });
            return super.visitTuple(tuple.withValues(newValues), (Object)p);
        }
        return super.visitTuple(tuple, (Object)p);
    }

    private boolean isMultiline(Hcl.Tuple tuple) {
        boolean multiLine = false;
        for (Expression value : tuple.getValues()) {
            if (!value.getPrefix().getLastWhitespace().contains("\n")) continue;
            multiLine = true;
        }
        return multiLine;
    }

    @Override
    public Hcl.Block visitBlock(Hcl.Block block, P p) {
        BodyContent first;
        List<BodyContent> body = block.getBody();
        if (!body.isEmpty() && !(first = body.get(0)).getPrefix().getLastWhitespace().contains("\n")) {
            ArrayList<BodyContent> newBody = new ArrayList<BodyContent>(body);
            newBody.set(0, first.withPrefix(first.getPrefix().withWhitespace("\n")));
            return super.visitBlock(block.withBody(newBody), (Object)p);
        }
        return super.visitBlock(block, (Object)p);
    }

    public @Nullable Hcl postVisit(Hcl tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Hcl.ConfigFile.class, "stop", (Object)true);
        }
        return (Hcl)super.postVisit((Tree)tree, p);
    }

    public @Nullable Hcl visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Hcl)tree;
        }
        return (Hcl)super.visit(tree, p);
    }
}

