/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hcl;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.hcl.HclIsoVisitor;
import org.openrewrite.hcl.JsonPathMatcher;
import org.openrewrite.hcl.tree.BodyContent;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.internal.lang.NonNull;

public final class DeleteContent
extends Recipe {
    @Option(displayName="Content path", description="A JSONPath expression specifying the block to delete.", example="$.provider")
    private final String contentPath;
    private final String displayName = "Delete content";
    private final String description = "Delete HCL content by path.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher pathMatcher = new JsonPathMatcher(this.contentPath);
        return new HclIsoVisitor<ExecutionContext>(){

            @Override
            public @Nullable BodyContent visitBodyContent(BodyContent bodyContent, ExecutionContext ctx) {
                Hcl b = super.visitBodyContent(bodyContent, ctx);
                if (pathMatcher.matches(this.getCursor())) {
                    return null;
                }
                return b;
            }
        };
    }

    @Generated
    public DeleteContent(String contentPath) {
        this.contentPath = contentPath;
    }

    @Generated
    public String getContentPath() {
        return this.contentPath;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DeleteContent(contentPath=" + this.getContentPath() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteContent)) {
            return false;
        }
        DeleteContent other = (DeleteContent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$contentPath = this.getContentPath();
        String other$contentPath = other.getContentPath();
        if (this$contentPath == null ? other$contentPath != null : !this$contentPath.equals(other$contentPath)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DeleteContent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contentPath = this.getContentPath();
        result = result * 59 + ($contentPath == null ? 43 : $contentPath.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

