/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy.format;

import java.util.List;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.openrewrite.style.StyleHelper;

public class SpacesVisitor<P>
extends org.openrewrite.java.format.SpacesVisitor<P> {
    public SpacesVisitor(SourceFile sourceFile, boolean removeCustomLineBreaks, @Nullable Tree stopAfter) {
        this(sourceFile.getMarkers().findAll(NamedStyles.class), removeCustomLineBreaks, stopAfter);
    }

    private SpacesVisitor(List<NamedStyles> styles, boolean removeCustomLineBreaks, @Nullable Tree stopAfter) {
        this(SpacesVisitor.getStyle(SpacesStyle.class, styles, IntelliJ::spaces), SpacesVisitor.getStyle(EmptyForInitializerPadStyle.class, styles), SpacesVisitor.getStyle(EmptyForIteratorPadStyle.class, styles), stopAfter, removeCustomLineBreaks);
    }

    public SpacesVisitor(SpacesStyle spacesStyle, @Nullable EmptyForInitializerPadStyle emptyForInitializerPadStyle, @Nullable EmptyForIteratorPadStyle emptyForIteratorPadStyle, @Nullable Tree stopAfter, boolean removeCustomLineBreaks) {
        super(spacesStyle, emptyForInitializerPadStyle, emptyForIteratorPadStyle, stopAfter, removeCustomLineBreaks);
    }

    public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, P p) {
        switch (loc) {
            case METHOD_SELECT: {
                loc = JRightPadded.Location.LANGUAGE_EXTENSION;
            }
        }
        return super.visitRightPadded(right, loc, p);
    }

    public <T> @Nullable JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, JLeftPadded.Location loc, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(@Nullable Space space, Space.Location loc, P ctx) {
        switch (loc) {
            case TERNARY_PREFIX: 
            case TERNARY_TRUE: 
            case TERNARY_FALSE: 
            case UNARY_PREFIX: 
            case UNARY_OPERATOR: 
            case BINARY_PREFIX: 
            case BINARY_OPERATOR: 
            case METHOD_SELECT_SUFFIX: 
            case METHOD_INVOCATION_NAME: {
                loc = Space.Location.LANGUAGE_EXTENSION;
            }
        }
        return super.visitSpace(space, loc, ctx);
    }

    private static <S extends Style> @Nullable S getStyle(Class<S> styleClass, List<NamedStyles> styles) {
        Style style = NamedStyles.merge(styleClass, styles);
        if (style != null) {
            return (S)style.applyDefaults();
        }
        return null;
    }

    private static <S extends Style> S getStyle(Class<S> styleClass, List<NamedStyles> styles, Supplier<S> defaultStyle) {
        Style style = NamedStyles.merge(styleClass, styles);
        if (style != null) {
            return (S)((Style)StyleHelper.merge((Object)((Style)defaultStyle.get()), (Object)style));
        }
        return (S)((Style)defaultStyle.get());
    }
}

