/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.search.DependencyInsight;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.marker.SearchResult;

public final class ModuleHasDependency
extends ScanningRecipe<Accumulator> {
    private final String displayName = "Module has dependency";
    private final String description = "Searches for Gradle Projects (modules) that have a dependency matching the specified id or implementing class. Places a `SearchResult` marker on all sources within a project with a matching dependency. This recipe is intended to be used as a precondition for other recipes. For example this could be used to limit the application of a spring boot migration to only projects that use spring-boot-starter, limiting unnecessary upgrading. If the search result you want is instead just the build.gradle(.kts) file that use the dependency, use the `FindDependency` recipe instead.";
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="com.fasterxml.jackson.module")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="jackson-module-*")
    private final String artifactIdPattern;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used.All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;
    @Option(displayName="Scope", description="Match dependencies with the specified scope. If not specified, all configurations will be searched.", example="compileClasspath", required=false)
    private final @Nullable String configuration;

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(new HashSet<JavaProject>());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                assert (tree != null);
                tree.getMarkers().findFirst(JavaProject.class).ifPresent(jp -> {
                    Tree t = new DependencyInsight(ModuleHasDependency.this.groupIdPattern, ModuleHasDependency.this.artifactIdPattern, ModuleHasDependency.this.version, ModuleHasDependency.this.configuration).getVisitor().visit(tree, (Object)ctx);
                    if (t != tree) {
                        acc.getProjectsWithDependency().add((JavaProject)jp);
                    }
                });
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                assert (tree != null);
                Optional maybeJp = tree.getMarkers().findFirst(JavaProject.class);
                if (!maybeJp.isPresent()) {
                    return tree;
                }
                JavaProject jp = (JavaProject)maybeJp.get();
                if (acc.getProjectsWithDependency().contains(jp)) {
                    return SearchResult.found((Tree)tree, (String)("Module has dependency: " + ModuleHasDependency.this.groupIdPattern + ":" + ModuleHasDependency.this.artifactIdPattern + (StringUtils.isNullOrEmpty((String)ModuleHasDependency.this.version) ? "" : ":" + ModuleHasDependency.this.version) + (StringUtils.isNullOrEmpty((String)ModuleHasDependency.this.configuration) ? "" : " in configuration ")));
                }
                return tree;
            }
        };
    }

    @Generated
    public ModuleHasDependency(String groupIdPattern, String artifactIdPattern, @Nullable String version, @Nullable String configuration) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
        this.version = version;
        this.configuration = configuration;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    @Generated
    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ModuleHasDependency(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", version=" + this.getVersion() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleHasDependency)) {
            return false;
        }
        ModuleHasDependency other = (ModuleHasDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ModuleHasDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }

    public static final class Accumulator {
        private final Set<JavaProject> projectsWithDependency;

        @Generated
        public Accumulator(Set<JavaProject> projectsWithDependency) {
            this.projectsWithDependency = projectsWithDependency;
        }

        @Generated
        public Set<JavaProject> getProjectsWithDependency() {
            return this.projectsWithDependency;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Set<JavaProject> this$projectsWithDependency = this.getProjectsWithDependency();
            Set<JavaProject> other$projectsWithDependency = other.getProjectsWithDependency();
            return !(this$projectsWithDependency == null ? other$projectsWithDependency != null : !((Object)this$projectsWithDependency).equals(other$projectsWithDependency));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<JavaProject> $projectsWithDependency = this.getProjectsWithDependency();
            result = result * 59 + ($projectsWithDependency == null ? 43 : ((Object)$projectsWithDependency).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ModuleHasDependency.Accumulator(projectsWithDependency=" + this.getProjectsWithDependency() + ")";
        }
    }
}

