/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.AlreadyReplaced;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.text.PlainTextVisitor;

public final class FindAndReplace
extends Recipe {
    private final String displayName = "Find and replace";
    private final String description = "Textual find and replace, optionally interpreting the search query as a Regular Expression (regex). When operating on source files that are language-specific Lossless Semantic Tree, such as Java or XML, this operation converts the source file to plain text for the rest of the recipe run. So if you are combining this recipe with language-specific recipes in a single recipe run put all the language-specific recipes before this recipe.";
    @Option(displayName="Find", description="The text to find (and replace). This snippet can be multiline.", example="blacklist")
    private final String find;
    @Option(displayName="Replace", description="The replacement text for `find`. This snippet can be multiline.", example="denylist", required=false)
    private final @Nullable String replace;
    @Option(displayName="Regex", description="Default false. If true, `find` will be interpreted as a [Regular Expression](https://en.wikipedia.org/wiki/Regular_expression), and capture group contents will be available in `replace`.", required=false)
    private final @Nullable Boolean regex;
    @Option(displayName="Case sensitive", description="If `true` the search will be sensitive to case. Default `false`.", required=false)
    private final @Nullable Boolean caseSensitive;
    @Option(displayName="Regex multiline mode", description="When performing a regex search setting this to `true` allows \"^\" and \"$\" to match the beginning and end of lines, respectively. When performing a regex search when this is `false` \"^\" and \"$\" will match only the beginning and ending of the entire source file, respectively.Has no effect when not performing a regex search. Default `false`.", required=false)
    private final @Nullable Boolean multiline;
    @Option(displayName="Regex dot all", description="When performing a regex search setting this to `true` allows \".\" to match line terminators.Has no effect when not performing a regex search. Default `false`.", required=false)
    private final @Nullable Boolean dotAll;
    @Option(displayName="File pattern", description="A glob expression that can be used to constrain which directories or source files should be searched. Multiple patterns may be specified, separated by a semicolon `;`. If multiple patterns are supplied any of the patterns matching will be interpreted as a match. When not set, all source files are searched.", required=false, example="**/*.java")
    private final @Nullable String filePattern;
    @Option(displayName="Plaintext only", description="Only alter files that are parsed as plaintext to prevent language-specific LST information loss. Defaults to false.", required=false)
    private final @Nullable Boolean plaintextOnly;

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor<Tree, ExecutionContext> visitor = new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                String newText;
                String replacement;
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                for (Marker marker : sourceFile.getMarkers().getMarkers()) {
                    if (!(marker instanceof AlreadyReplaced)) continue;
                    AlreadyReplaced alreadyReplaced = (AlreadyReplaced)marker;
                    if (!Objects.equals(FindAndReplace.this.find, alreadyReplaced.getFind()) || !Objects.equals(FindAndReplace.this.replace, alreadyReplaced.getReplace())) continue;
                    return sourceFile;
                }
                PlainText plainText = PlainTextParser.convert(sourceFile);
                String string = replacement = FindAndReplace.this.replace == null ? "" : FindAndReplace.this.replace;
                if (!Boolean.TRUE.equals(FindAndReplace.this.regex)) {
                    replacement = replacement.replace("$", "\\$");
                }
                if (!Boolean.TRUE.equals(FindAndReplace.this.regex) && Boolean.TRUE.equals(FindAndReplace.this.caseSensitive)) {
                    newText = plainText.getText().replace(FindAndReplace.this.find, replacement);
                } else {
                    int patternOptions = 0;
                    if (!Boolean.TRUE.equals(FindAndReplace.this.regex)) {
                        patternOptions |= 0x10;
                    }
                    if (!Boolean.TRUE.equals(FindAndReplace.this.caseSensitive)) {
                        patternOptions |= 2;
                    }
                    if (Boolean.TRUE.equals(FindAndReplace.this.multiline)) {
                        patternOptions |= 8;
                    }
                    if (Boolean.TRUE.equals(FindAndReplace.this.dotAll)) {
                        patternOptions |= 0x20;
                    }
                    Pattern pattern = Pattern.compile(FindAndReplace.this.find, patternOptions);
                    newText = pattern.matcher(plainText.getText()).replaceAll(replacement);
                }
                if (newText.equals(plainText.getText())) {
                    return sourceFile;
                }
                return plainText.withText(newText).withMarkers(plainText.getMarkers().add(new AlreadyReplaced(Tree.randomId(), FindAndReplace.this.find, FindAndReplace.this.replace)));
            }
        };
        if (this.filePattern != null) {
            visitor = Preconditions.check(new FindSourceFiles(this.filePattern), visitor);
        }
        if (Boolean.TRUE.equals(this.plaintextOnly)) {
            visitor = Preconditions.check(new PlainTextVisitor<ExecutionContext>(){

                @Override
                public PlainText visitText(PlainText text, ExecutionContext ctx) {
                    return SearchResult.found(text);
                }
            }, visitor);
        }
        return visitor;
    }

    @Generated
    public FindAndReplace(String find, @Nullable String replace, @Nullable Boolean regex, @Nullable Boolean caseSensitive, @Nullable Boolean multiline, @Nullable Boolean dotAll, @Nullable String filePattern, @Nullable Boolean plaintextOnly) {
        this.find = find;
        this.replace = replace;
        this.regex = regex;
        this.caseSensitive = caseSensitive;
        this.multiline = multiline;
        this.dotAll = dotAll;
        this.filePattern = filePattern;
        this.plaintextOnly = plaintextOnly;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getFind() {
        return this.find;
    }

    @Generated
    public @Nullable String getReplace() {
        return this.replace;
    }

    @Generated
    public @Nullable Boolean getRegex() {
        return this.regex;
    }

    @Generated
    public @Nullable Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    @Generated
    public @Nullable Boolean getMultiline() {
        return this.multiline;
    }

    @Generated
    public @Nullable Boolean getDotAll() {
        return this.dotAll;
    }

    @Generated
    public @Nullable String getFilePattern() {
        return this.filePattern;
    }

    @Generated
    public @Nullable Boolean getPlaintextOnly() {
        return this.plaintextOnly;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindAndReplace(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", find=" + this.getFind() + ", replace=" + this.getReplace() + ", regex=" + this.getRegex() + ", caseSensitive=" + this.getCaseSensitive() + ", multiline=" + this.getMultiline() + ", dotAll=" + this.getDotAll() + ", filePattern=" + this.getFilePattern() + ", plaintextOnly=" + this.getPlaintextOnly() + ")";
    }

    @Override
    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindAndReplace)) {
            return false;
        }
        FindAndReplace other = (FindAndReplace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$regex = this.getRegex();
        Boolean other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !((Object)this$regex).equals(other$regex)) {
            return false;
        }
        Boolean this$caseSensitive = this.getCaseSensitive();
        Boolean other$caseSensitive = other.getCaseSensitive();
        if (this$caseSensitive == null ? other$caseSensitive != null : !((Object)this$caseSensitive).equals(other$caseSensitive)) {
            return false;
        }
        Boolean this$multiline = this.getMultiline();
        Boolean other$multiline = other.getMultiline();
        if (this$multiline == null ? other$multiline != null : !((Object)this$multiline).equals(other$multiline)) {
            return false;
        }
        Boolean this$dotAll = this.getDotAll();
        Boolean other$dotAll = other.getDotAll();
        if (this$dotAll == null ? other$dotAll != null : !((Object)this$dotAll).equals(other$dotAll)) {
            return false;
        }
        Boolean this$plaintextOnly = this.getPlaintextOnly();
        Boolean other$plaintextOnly = other.getPlaintextOnly();
        if (this$plaintextOnly == null ? other$plaintextOnly != null : !((Object)this$plaintextOnly).equals(other$plaintextOnly)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$find = this.getFind();
        String other$find = other.getFind();
        if (this$find == null ? other$find != null : !this$find.equals(other$find)) {
            return false;
        }
        String this$replace = this.getReplace();
        String other$replace = other.getReplace();
        if (this$replace == null ? other$replace != null : !this$replace.equals(other$replace)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindAndReplace;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : ((Object)$regex).hashCode());
        Boolean $caseSensitive = this.getCaseSensitive();
        result = result * 59 + ($caseSensitive == null ? 43 : ((Object)$caseSensitive).hashCode());
        Boolean $multiline = this.getMultiline();
        result = result * 59 + ($multiline == null ? 43 : ((Object)$multiline).hashCode());
        Boolean $dotAll = this.getDotAll();
        result = result * 59 + ($dotAll == null ? 43 : ((Object)$dotAll).hashCode());
        Boolean $plaintextOnly = this.getPlaintextOnly();
        result = result * 59 + ($plaintextOnly == null ? 43 : ((Object)$plaintextOnly).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $find = this.getFind();
        result = result * 59 + ($find == null ? 43 : $find.hashCode());
        String $replace = this.getReplace();
        result = result * 59 + ($replace == null ? 43 : $replace.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

