/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;

public final class ChangeText
extends Recipe {
    @Option(displayName="Text after change", description="The text file will have only this text after the change. The snippet provided here can be multiline.", example="Some text.")
    private final String toText;
    private final Set<String> tags = Collections.singleton("plain text");
    private final String displayName = "Change text";
    private final String description = "Completely replaces the contents of the text file with other text. Use together with a `FindSourceFiles` precondition to limit which files are changed.";

    @Override
    public String getInstanceNameSuffix() {
        return "to `" + this.toText + "`";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                PlainText plainText = PlainTextParser.convert(sourceFile);
                return plainText.withText(ChangeText.this.toText);
            }
        };
    }

    @Generated
    public ChangeText(String toText) {
        this.toText = toText;
    }

    @Generated
    public String getToText() {
        return this.toText;
    }

    @Override
    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeText(toText=" + this.getToText() + ", tags=" + this.getTags() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Override
    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeText)) {
            return false;
        }
        ChangeText other = (ChangeText)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$toText = this.getToText();
        String other$toText = other.getToText();
        if (this$toText == null ? other$toText != null : !this$toText.equals(other$toText)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeText;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $toText = this.getToText();
        result = result * 59 + ($toText == null ? 43 : $toText.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

