/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;

@JsonIgnoreType
public class DeserializationErrorTable
extends DataTable<Row> {
    public DeserializationErrorTable(Recipe recipe) {
        super(recipe, "Deserialization errors", "Table collecting any LST deserialization errors.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The source that failed to be deserialized.")
        private final String sourcePath;
        @Column(displayName="Error message", description="The error message of the exception that produced the error.")
        private final @Nullable String errorMessage;
        @Column(displayName="Stack trace", description="The stack trace of the error.")
        private final String stackTrace;
        @Column(displayName="Language", description="Language of source file in case it requires a newer CLI version for the ingestion.")
        private final @Nullable String language;
        @Column(displayName="Minimum CLI version required by language", description="Minimum CLI version required to be able to successfully ingest sources of this language.")
        private final @Nullable String minimumVersion;
        @Column(displayName="Actual CLI version used for ingestion", description="Actual CLI version used to ingest this source.")
        private final @Nullable String actualVersion;
        @Column(displayName="Timestamp (epoch millis)", description="UTC timestamp describing when the LST was produced, in milliseconds since the unix epoch.")
        private final @Nullable Long timestampEpochMillis;
        @Column(displayName="Timestamp", description="UTC timestamp describing when the LST was produced, in ISO-8601 format. e.g.: \"2023\u201008\u201007T22:24:06+00:00 UTC+00:00\"")
        private final @Nullable String timestampUtc;

        @Generated
        public Row(String sourcePath, @Nullable String errorMessage, String stackTrace, @Nullable String language, @Nullable String minimumVersion, @Nullable String actualVersion, @Nullable Long timestampEpochMillis, @Nullable String timestampUtc) {
            this.sourcePath = sourcePath;
            this.errorMessage = errorMessage;
            this.stackTrace = stackTrace;
            this.language = language;
            this.minimumVersion = minimumVersion;
            this.actualVersion = actualVersion;
            this.timestampEpochMillis = timestampEpochMillis;
            this.timestampUtc = timestampUtc;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public @Nullable String getErrorMessage() {
            return this.errorMessage;
        }

        @Generated
        public String getStackTrace() {
            return this.stackTrace;
        }

        @Generated
        public @Nullable String getLanguage() {
            return this.language;
        }

        @Generated
        public @Nullable String getMinimumVersion() {
            return this.minimumVersion;
        }

        @Generated
        public @Nullable String getActualVersion() {
            return this.actualVersion;
        }

        @Generated
        public @Nullable Long getTimestampEpochMillis() {
            return this.timestampEpochMillis;
        }

        @Generated
        public @Nullable String getTimestampUtc() {
            return this.timestampUtc;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Long this$timestampEpochMillis = this.getTimestampEpochMillis();
            Long other$timestampEpochMillis = other.getTimestampEpochMillis();
            if (this$timestampEpochMillis == null ? other$timestampEpochMillis != null : !((Object)this$timestampEpochMillis).equals(other$timestampEpochMillis)) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$errorMessage = this.getErrorMessage();
            String other$errorMessage = other.getErrorMessage();
            if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
                return false;
            }
            String this$stackTrace = this.getStackTrace();
            String other$stackTrace = other.getStackTrace();
            if (this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace)) {
                return false;
            }
            String this$language = this.getLanguage();
            String other$language = other.getLanguage();
            if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
                return false;
            }
            String this$minimumVersion = this.getMinimumVersion();
            String other$minimumVersion = other.getMinimumVersion();
            if (this$minimumVersion == null ? other$minimumVersion != null : !this$minimumVersion.equals(other$minimumVersion)) {
                return false;
            }
            String this$actualVersion = this.getActualVersion();
            String other$actualVersion = other.getActualVersion();
            if (this$actualVersion == null ? other$actualVersion != null : !this$actualVersion.equals(other$actualVersion)) {
                return false;
            }
            String this$timestampUtc = this.getTimestampUtc();
            String other$timestampUtc = other.getTimestampUtc();
            return !(this$timestampUtc == null ? other$timestampUtc != null : !this$timestampUtc.equals(other$timestampUtc));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $timestampEpochMillis = this.getTimestampEpochMillis();
            result = result * 59 + ($timestampEpochMillis == null ? 43 : ((Object)$timestampEpochMillis).hashCode());
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $errorMessage = this.getErrorMessage();
            result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
            String $stackTrace = this.getStackTrace();
            result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
            String $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            String $minimumVersion = this.getMinimumVersion();
            result = result * 59 + ($minimumVersion == null ? 43 : $minimumVersion.hashCode());
            String $actualVersion = this.getActualVersion();
            result = result * 59 + ($actualVersion == null ? 43 : $actualVersion.hashCode());
            String $timestampUtc = this.getTimestampUtc();
            result = result * 59 + ($timestampUtc == null ? 43 : $timestampUtc.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DeserializationErrorTable.Row(sourcePath=" + this.getSourcePath() + ", errorMessage=" + this.getErrorMessage() + ", stackTrace=" + this.getStackTrace() + ", language=" + this.getLanguage() + ", minimumVersion=" + this.getMinimumVersion() + ", actualVersion=" + this.getActualVersion() + ", timestampEpochMillis=" + this.getTimestampEpochMillis() + ", timestampUtc=" + this.getTimestampUtc() + ")";
        }
    }
}

