/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.semver;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.StringUtils;

public interface VersionComparator
extends Comparator<String> {
    public static final Pattern RELEASE_PATTERN = Pattern.compile("(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+))?([-.+].*)?");
    public static final String[] RELEASE_SUFFIXES = new String[]{".final", ".ga", ".release"};
    public static final Pattern PRE_RELEASE_ENDING = Pattern.compile("[.-](alpha|a|beta|b|milestone|m|rc|cr|snapshot)[.-]?\\d*$", 2);

    public boolean isValid(@Nullable String var1, String var2);

    @Override
    @Deprecated
    default public int compare(String v1, String v2) {
        return this.compare(null, v1, v2);
    }

    public int compare(@Nullable String var1, String var2, String var3);

    default public Optional<String> upgrade(String currentVersion, Collection<String> availableVersions) {
        boolean seen = false;
        String best = null;
        for (String availableVersion : availableVersions) {
            if (!this.isValid(currentVersion, availableVersion) || this.compare(currentVersion, currentVersion, availableVersion) > 0 || seen && this.compare(currentVersion, availableVersion, best) <= 0) continue;
            seen = true;
            best = availableVersion;
        }
        return (seen ? Optional.of(best) : Optional.empty()).filter(v -> !v.equals(currentVersion));
    }

    public static boolean checkVersion(String version, @Nullable String metadataPattern, boolean requireRelease) {
        Matcher matcher = RELEASE_PATTERN.matcher(version);
        if (!matcher.matches()) {
            return false;
        }
        if (requireRelease && PRE_RELEASE_ENDING.matcher(version).find()) {
            return false;
        }
        boolean requireMeta = !StringUtils.isNullOrEmpty(metadataPattern);
        String versionMeta = matcher.group(6);
        if (requireMeta) {
            return versionMeta != null && versionMeta.matches(metadataPattern);
        }
        if (versionMeta == null) {
            return true;
        }
        if (requireRelease) {
            String lowercaseVersionMeta = versionMeta.toLowerCase();
            for (String suffix : RELEASE_SUFFIXES) {
                if (!suffix.equals(lowercaseVersionMeta)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

