/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.search;

import java.util.Collections;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.InMemoryDiffEntry;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.table.ParseToPrintInequalities;
import org.openrewrite.tree.ParseError;

public class FindParseToPrintInequality
extends Recipe {
    transient ParseToPrintInequalities inequalities = new ParseToPrintInequalities(this);
    final String displayName = "Find parse to print inequality";
    final String description = "OpenRewrite `Parser` implementations should produce `SourceFile` objects whose `printAll()` method should be byte-for-byte equivalent with the original source file. When this isn't true, recipes can still run on the `SourceFile` and even produce diffs, but the diffs would fail to apply as a patch to the original source file. Most `Parser` use `Parser#requirePrintEqualsInput` to produce a `ParseError` when they fail to produce a `SourceFile` that is print idempotent.";

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                ParseError parseError;
                if (tree instanceof ParseError && (parseError = (ParseError)tree).getErroneous() != null) {
                    try (InMemoryDiffEntry diffEntry = new InMemoryDiffEntry(parseError.getSourcePath(), parseError.getSourcePath(), null, parseError.getText(), parseError.getErroneous().printAll(), Collections.emptySet());){
                        FindParseToPrintInequality.this.inequalities.insertRow(ctx, new ParseToPrintInequalities.Row(parseError.getSourcePath().toString(), diffEntry.getDiff(false)));
                    }
                    return SearchResult.found(parseError);
                }
                return super.visit(tree, ctx);
            }
        };
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }
}

