/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.search;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.BuildMetadata;
import org.openrewrite.marker.SearchResult;

public final class FindBuildMetadata
extends Recipe {
    @Option(displayName="Build metadata key", description="The key to search for in the build metadata.", example="lstFormatVersion")
    private final String key;
    @Option(displayName="Build metadata value", description="The value to search for in the build metadata.", example="2")
    private final String value;
    private final String displayName = "Find build metadata";
    private final String description = "Find source files with matching build metadata.";

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    for (BuildMetadata buildMetadata : tree.getMarkers().findAll(BuildMetadata.class)) {
                        if (!buildMetadata.getMetadata().containsKey(FindBuildMetadata.this.key) || !buildMetadata.getMetadata().get(FindBuildMetadata.this.key).equals(FindBuildMetadata.this.value)) continue;
                        return SearchResult.found(tree, "Found build metadata");
                    }
                }
                return tree;
            }
        };
    }

    @Generated
    public FindBuildMetadata(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindBuildMetadata(key=" + this.getKey() + ", value=" + this.getValue() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Override
    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindBuildMetadata)) {
            return false;
        }
        FindBuildMetadata other = (FindBuildMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindBuildMetadata;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

