/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.scheduling;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.scheduling.RecipeRunCycle;

@Incubating(since="8.12.0")
public class WorkingDirectoryExecutionContextView
extends DelegatingExecutionContext {
    public static final String WORKING_DIRECTORY_ROOT = "org.openrewrite.scheduling.workingDirectory";

    private WorkingDirectoryExecutionContextView(ExecutionContext delegate) {
        super(delegate);
    }

    public static WorkingDirectoryExecutionContextView view(ExecutionContext ctx) {
        return new WorkingDirectoryExecutionContextView(ctx);
    }

    public void setRoot(Path path) {
        if (this.getMessage("org.openrewrite.currentCycle") != null) {
            throw new IllegalStateException("The root working directory cannot be set once recipe execution has begun.");
        }
        this.putMessage(WORKING_DIRECTORY_ROOT, path);
    }

    public Path getWorkingDirectory() {
        try {
            Path root = (Path)this.getMessage(WORKING_DIRECTORY_ROOT);
            if (root == null) {
                root = Files.createTempDirectory("rewrite-work", new FileAttribute[0]);
                this.putMessage(WORKING_DIRECTORY_ROOT, root);
            }
            RecipeRunCycle<?> cycle = this.getCycleDetails();
            return Files.createDirectories(root.resolve("cycle" + cycle.getCycle() + "_recipe" + cycle.getRecipePosition()), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

