/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleResolver;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class GetMarketplaceResponse
extends ArrayList<Row> {
    public RecipeMarketplace toMarketplace(RecipeBundle bundle) {
        RecipeMarketplace marketplace = new RecipeMarketplace();
        for (Row recipe : this) {
            for (List<CategoryDescriptor> categoryPath : recipe.getCategoryPaths()) {
                marketplace.install(RecipeListing.fromDescriptor(recipe.getDescriptor(), bundle), categoryPath);
            }
        }
        return marketplace;
    }

    public static GetMarketplaceResponse fromMarketplace(RecipeMarketplace marketplace, List<RecipeBundleResolver> resolvers) {
        LinkedHashMap<String, Row> rowByRecipeId = new LinkedHashMap<String, Row>();
        for (RecipeMarketplace.Category category : marketplace.getCategories()) {
            GetMarketplaceResponse.fromCategory(resolvers, rowByRecipeId, category, new ArrayList<CategoryDescriptor>());
        }
        GetMarketplaceResponse response = new GetMarketplaceResponse();
        response.addAll(rowByRecipeId.values());
        return response;
    }

    private static void fromCategory(List<RecipeBundleResolver> resolvers, Map<String, Row> rowByRecipeId, RecipeMarketplace.Category category, List<CategoryDescriptor> parentCategory) {
        ArrayList<CategoryDescriptor> categoryPath = new ArrayList<CategoryDescriptor>(parentCategory);
        categoryPath.add(new CategoryDescriptor(category.getDisplayName(), "", category.getDescription(), Collections.emptySet(), false, 0, false));
        for (RecipeListing recipe : category.getRecipes()) {
            rowByRecipeId.computeIfAbsent(recipe.getName(), recipeId -> new Row(recipe.describe(resolvers), new ArrayList<List<CategoryDescriptor>>())).categoryPaths.add(categoryPath);
        }
        for (RecipeMarketplace.Category child : category.getCategories()) {
            GetMarketplaceResponse.fromCategory(resolvers, rowByRecipeId, child, categoryPath);
        }
    }

    public static final class Row {
        private final RecipeDescriptor descriptor;
        private final List<List<CategoryDescriptor>> categoryPaths;

        @Generated
        public Row(RecipeDescriptor descriptor, List<List<CategoryDescriptor>> categoryPaths) {
            this.descriptor = descriptor;
            this.categoryPaths = categoryPaths;
        }

        @Generated
        public RecipeDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Generated
        public List<List<CategoryDescriptor>> getCategoryPaths() {
            return this.categoryPaths;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            RecipeDescriptor this$descriptor = this.getDescriptor();
            RecipeDescriptor other$descriptor = other.getDescriptor();
            if (this$descriptor == null ? other$descriptor != null : !((Object)this$descriptor).equals(other$descriptor)) {
                return false;
            }
            List<List<CategoryDescriptor>> this$categoryPaths = this.getCategoryPaths();
            List<List<CategoryDescriptor>> other$categoryPaths = other.getCategoryPaths();
            return !(this$categoryPaths == null ? other$categoryPaths != null : !((Object)this$categoryPaths).equals(other$categoryPaths));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RecipeDescriptor $descriptor = this.getDescriptor();
            result = result * 59 + ($descriptor == null ? 43 : ((Object)$descriptor).hashCode());
            List<List<CategoryDescriptor>> $categoryPaths = this.getCategoryPaths();
            result = result * 59 + ($categoryPaths == null ? 43 : ((Object)$categoryPaths).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "GetMarketplaceResponse.Row(descriptor=" + this.getDescriptor() + ", categoryPaths=" + this.getCategoryPaths() + ")";
        }
    }
}

