/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import io.moderne.jsonrpc.JsonRpc;
import io.moderne.jsonrpc.JsonRpcMethod;
import io.moderne.jsonrpc.JsonRpcRequest;
import io.moderne.jsonrpc.JsonRpcSuccess;
import io.moderne.jsonrpc.internal.SnowflakeId;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.internal.RecipeLoader;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleResolver;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;
import org.openrewrite.rpc.RpcObjectData;
import org.openrewrite.rpc.RpcReceiveQueue;
import org.openrewrite.rpc.RpcRecipe;
import org.openrewrite.rpc.internal.PreparedRecipeCache;
import org.openrewrite.rpc.request.Generate;
import org.openrewrite.rpc.request.GenerateResponse;
import org.openrewrite.rpc.request.GetMarketplaceResponse;
import org.openrewrite.rpc.request.GetObject;
import org.openrewrite.rpc.request.GetObjectResponse;
import org.openrewrite.rpc.request.Parse;
import org.openrewrite.rpc.request.ParseResponse;
import org.openrewrite.rpc.request.PrepareRecipe;
import org.openrewrite.rpc.request.PrepareRecipeResponse;
import org.openrewrite.rpc.request.Print;
import org.openrewrite.rpc.request.RpcRequest;
import org.openrewrite.rpc.request.TraceGetObject;
import org.openrewrite.rpc.request.Visit;
import org.openrewrite.rpc.request.VisitResponse;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class RewriteRpc {
    private final JsonRpc jsonRpc;
    private final AtomicInteger batchSize = new AtomicInteger(1000);
    private Duration timeout = Duration.ofSeconds(30L);
    private Supplier<? extends @Nullable RuntimeException> livenessCheck = () -> null;
    private final AtomicReference<@Nullable PrintStream> log = new AtomicReference();
    private final AtomicReference<TraceGetObject> traceGetObject = new AtomicReference<TraceGetObject>(new TraceGetObject(false, false));
    final PreparedRecipeCache preparedRecipes = new PreparedRecipeCache();
    @VisibleForTesting
    final Map<String, Object> remoteObjects = new HashMap<String, Object>();
    @VisibleForTesting
    final Map<String, Object> localObjects = new HashMap<String, Object>();
    final Map<Object, String> localObjectIds = new IdentityHashMap<Object, String>();
    @VisibleForTesting
    final Map<Integer, Object> remoteRefs = new HashMap<Integer, Object>();
    @VisibleForTesting
    final IdentityHashMap<Object, Integer> localRefs = new IdentityHashMap();
    private @Nullable List<String> remoteLanguages;

    public RewriteRpc(JsonRpc jsonRpc, RecipeMarketplace marketplace) {
        this(jsonRpc, marketplace, Collections.emptyList());
    }

    public RewriteRpc(JsonRpc jsonRpc, final RecipeMarketplace marketplace, final List<RecipeBundleResolver> resolvers) {
        this.jsonRpc = jsonRpc;
        jsonRpc.rpc("Visit", (JsonRpcMethod)new Visit.Handler(this.localObjects, this.preparedRecipes, this::getObject, this::getCursor));
        jsonRpc.rpc("Generate", (JsonRpcMethod)new Generate.Handler(this.localObjects, this.preparedRecipes, this::getObject));
        jsonRpc.rpc("GetObject", (JsonRpcMethod)new GetObject.Handler(this.batchSize, this.remoteObjects, this.localObjects, this.localRefs, this.log, () -> this.traceGetObject.get().isSend()));
        jsonRpc.rpc("GetMarketplace", (JsonRpcMethod)new JsonRpcMethod<Void>(){

            protected Object handle(Void noParams) {
                return GetMarketplaceResponse.fromMarketplace(marketplace, resolvers);
            }
        });
        jsonRpc.rpc("TraceGetObject", (JsonRpcMethod)new JsonRpcMethod<TraceGetObject>(){

            protected Boolean handle(TraceGetObject request) {
                RewriteRpc.this.traceGetObject.set(request);
                return true;
            }
        });
        jsonRpc.rpc("GetLanguages", (JsonRpcMethod)new JsonRpcMethod<Void>(){

            protected Object handle(Void noParams) {
                return Stream.of(this.ifOnClasspath("org.openrewrite.text.PlainText"), this.ifOnClasspath("org.openrewrite.json.tree.Json$Document"), this.ifOnClasspath("org.openrewrite.java.tree.J$CompilationUnit"), this.ifOnClasspath("org.openrewrite.javascript.tree.JS$CompilationUnit")).filter(Objects::nonNull).toArray(String[]::new);
            }

            private @Nullable String ifOnClasspath(String className) {
                try {
                    Class.forName(className);
                    return className;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        });
        jsonRpc.rpc("PrepareRecipe", (JsonRpcMethod)new PrepareRecipe.Handler(this.preparedRecipes, (id, opts) -> {
            RecipeListing listing = marketplace.findRecipe(id);
            if (listing != null) {
                return listing.prepare(resolvers, opts);
            }
            return new RecipeLoader(null).load(id, (Map<String, Object>)opts);
        }));
        jsonRpc.rpc("Print", (JsonRpcMethod)new Print.Handler(this::getObject));
        jsonRpc.bind();
    }

    public RewriteRpc livenessCheck(Supplier<? extends @Nullable RuntimeException> livenessCheck) {
        this.livenessCheck = livenessCheck;
        return this;
    }

    public RewriteRpc timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public RewriteRpc batchSize(int batchSize) {
        this.batchSize.set(batchSize);
        return this;
    }

    public RewriteRpc log(@Nullable PrintStream logFile) {
        this.log.set(logFile);
        return this;
    }

    public void shutdown() {
        PrintStream logOut = this.log.get();
        if (logOut != null) {
            logOut.close();
        }
        this.jsonRpc.shutdown();
    }

    public void reset() {
        this.send("Reset", null, Boolean.class);
        this.remoteObjects.clear();
        this.localObjects.clear();
        this.localObjectIds.clear();
        this.remoteRefs.clear();
        this.localRefs.clear();
        this.remoteLanguages = null;
    }

    public <P> @Nullable Tree visit(SourceFile sourceFile, String visitorName, P p) {
        return this.visit(sourceFile, visitorName, p, null);
    }

    public <P> @Nullable Tree visit(Tree tree, String visitorName, P p, @Nullable Cursor cursor) {
        this.localObjects.put(tree.getId().toString(), tree);
        String pId = this.maybeUnwrapExecutionContext(p);
        List<String> cursorIds = this.getCursorIds(cursor);
        String sourceFileType = (tree instanceof SourceFile ? tree : (Tree)Objects.requireNonNull(cursor).firstEnclosingOrThrow(SourceFile.class)).getClass().getName();
        VisitResponse response = this.send("Visit", new Visit(visitorName, sourceFileType, null, tree.getId().toString(), pId, cursorIds), VisitResponse.class);
        return response.isModified() ? (Tree)this.getObject(tree.getId().toString(), sourceFileType) : tree;
    }

    public Collection<? extends SourceFile> generate(String remoteRecipeId, ExecutionContext ctx) {
        String ctxId = this.maybeUnwrapExecutionContext(ctx);
        GenerateResponse response = this.send("Generate", new Generate(remoteRecipeId, ctxId), GenerateResponse.class);
        if (!response.getIds().isEmpty()) {
            ArrayList<SourceFile> generated = new ArrayList<SourceFile>(response.getIds().size());
            for (int i = 0; i < response.getIds().size(); ++i) {
                String id = response.getIds().get(i);
                generated.add((SourceFile)this.getObject(id, response.getSourceFileTypes().get(i)));
            }
            return generated;
        }
        return Collections.emptyList();
    }

    private <P> String maybeUnwrapExecutionContext(P p) {
        Object p2 = p;
        while (p2 instanceof DelegatingExecutionContext) {
            p2 = ((DelegatingExecutionContext)p2).getDelegate();
        }
        String pId = this.localObjectIds.computeIfAbsent(p2, p3 -> SnowflakeId.generateId());
        if (p2 instanceof ExecutionContext) {
            ((ExecutionContext)p2).putMessage("org.openrewrite.rpc.id", pId);
        }
        this.localObjects.put(pId, p2);
        return pId;
    }

    public RecipeMarketplace getMarketplace(RecipeBundle bundle) {
        return this.send("GetMarketplace", null, GetMarketplaceResponse.class).toMarketplace(bundle);
    }

    public List<String> getLanguages() {
        if (this.remoteLanguages == null) {
            this.remoteLanguages = Arrays.asList(this.send("GetLanguages", null, String[].class));
        }
        return this.remoteLanguages;
    }

    public RpcRecipe prepareRecipe(String id) {
        return this.prepareRecipe(id, Collections.emptyMap());
    }

    public RpcRecipe prepareRecipe(String id, Map<String, Object> options) {
        PrepareRecipeResponse r = this.send("PrepareRecipe", new PrepareRecipe(id, options), PrepareRecipeResponse.class);
        for (OptionDescriptor option : r.getDescriptor().getOptions()) {
            if (!option.isRequired() || options.containsKey(option.getName())) continue;
            throw new IllegalArgumentException("Missing required option `" + option.getName() + "` for recipe `" + id + "`.");
        }
        return new RpcRecipe(this, r.getId(), r.getDescriptor(), r.getEditVisitor(), this.matchAll(r.getEditPreconditions()), r.getScanVisitor(), this.matchAll(r.getScanPreconditions()));
    }

    private @Nullable TreeVisitor<?, ExecutionContext> matchAll(List<PrepareRecipeResponse.Precondition> preconditions) {
        if (preconditions.isEmpty()) {
            return null;
        }
        final ArrayList visitors = new ArrayList(preconditions.size());
        for (PrepareRecipeResponse.Precondition p : preconditions) {
            visitors.add(this.preparedRecipes.instantiateVisitor(p.getVisitorName(), p.getVisitorOptions()));
        }
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @Nullable Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                Tree t = tree;
                for (TreeVisitor v : visitors) {
                    t = v.visit(tree, ctx);
                    if (t != tree) continue;
                    return tree;
                }
                return t;
            }
        };
    }

    public Stream<SourceFile> parse(Iterable<Parser.Input> inputs, final @Nullable Path relativeTo, final Parser parser, final String sourceFileType, final ExecutionContext ctx) {
        final ArrayList<Parser.Input> inputList = new ArrayList<Parser.Input>();
        final ArrayList<Parse.Input> mappedInputs = new ArrayList<Parse.Input>();
        for (Parser.Input input : inputs) {
            inputList.add(input);
            if (input.isSynthetic() || !Files.isRegularFile(input.getPath(), new LinkOption[0])) {
                mappedInputs.add(new Parse.StringInput(input.getSource(ctx).readFully(), input.getPath()));
                continue;
            }
            mappedInputs.add(new Parse.PathInput(input.getPath()));
        }
        if (inputList.isEmpty()) {
            return Stream.empty();
        }
        final ParsingEventListener parsingListener = ParsingExecutionContextView.view(ctx).getParsingListener();
        parsingListener.intermediateMessage(String.format("Starting parsing of %,d files", inputList.size()));
        return StreamSupport.stream(new Spliterator<SourceFile>(){
            private int index = 0;
            private @Nullable List<String> ids;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean tryAdvance(Consumer<? super SourceFile> action) {
                if (this.ids == null) {
                    this.ids = RewriteRpc.this.send("Parse", new Parse(mappedInputs, relativeTo != null ? relativeTo.toString() : null), ParseResponse.class);
                    assert (this.ids.size() == inputList.size());
                }
                if (this.index >= inputList.size()) {
                    return false;
                }
                Parser.Input input = (Parser.Input)inputList.get(this.index);
                String id = this.ids.get(this.index);
                ++this.index;
                SourceFile sourceFile = null;
                parsingListener.startedParsing(input);
                try {
                    sourceFile = (SourceFile)RewriteRpc.this.getObject(id, sourceFileType);
                    if (sourceFile != null) {
                        action.accept(sourceFile);
                        parsingListener.parsed(input, sourceFile);
                    }
                }
                catch (Exception e) {
                    try {
                        sourceFile = ParseError.build(parser, input, relativeTo, ctx, e);
                        if (sourceFile != null) {
                            action.accept(sourceFile);
                            parsingListener.parsed(input, sourceFile);
                        }
                    }
                    catch (Throwable throwable) {
                        if (sourceFile != null) {
                            action.accept(sourceFile);
                            parsingListener.parsed(input, sourceFile);
                        }
                        throw throwable;
                    }
                }
                return true;
            }

            @Override
            public @Nullable Spliterator<SourceFile> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return inputList.size() - this.index;
            }

            @Override
            public int characteristics() {
                return 16464;
            }
        }, false);
    }

    public String print(SourceFile tree) {
        return this.print(tree, new Cursor(null, tree), null);
    }

    public String print(SourceFile tree, @Nullable Print.MarkerPrinter markerPrinter) {
        return this.print(tree, new Cursor(null, tree), markerPrinter);
    }

    public String print(Tree tree, Cursor parent) {
        return this.print(tree, parent, null);
    }

    public String print(Tree tree, Cursor parent, @Nullable Print.MarkerPrinter markerPrinter) {
        String treeId = tree.getId().toString();
        this.localObjects.put(treeId, tree);
        SourceFile sourceFile = tree instanceof SourceFile ? (SourceFile)tree : parent.firstEnclosingOrThrow(SourceFile.class);
        String sourceFileType = sourceFile.getClass().getName();
        return this.send("Print", new Print(treeId, sourceFile.getSourcePath(), sourceFileType, markerPrinter), String.class);
    }

    public RewriteRpc traceGetObject(boolean receive, boolean send) {
        this.traceGetObject.set(new TraceGetObject(receive, send));
        this.send("TraceGetObject", new TraceGetObject(receive, send), Boolean.class);
        return this;
    }

    @VisibleForTesting
    @Nullable List<String> getCursorIds(@Nullable Cursor cursor) {
        List cursorIds = null;
        if (cursor != null) {
            cursorIds = cursor.getPathAsStream().map(c -> {
                String id = c instanceof Tree ? ((Tree)c).getId().toString() : this.localObjectIds.computeIfAbsent(c, c2 -> SnowflakeId.generateId());
                this.localObjects.put(id, c);
                return id;
            }).collect(Collectors.toList());
        }
        return cursorIds;
    }

    @VisibleForTesting
    public <T> T getObject(String id, @Nullable String sourceFileType) {
        Object localObject = this.localObjects.get(id);
        RpcReceiveQueue q = new RpcReceiveQueue(this.remoteRefs, () -> this.send("GetObject", new GetObject(id, sourceFileType), GetObjectResponse.class), sourceFileType, this.log.get());
        Object remoteObject = q.receive(localObject, null);
        if (q.take().getState() != RpcObjectData.State.END_OF_OBJECT) {
            throw new IllegalStateException("Expected END_OF_OBJECT");
        }
        if (remoteObject != null) {
            this.remoteObjects.put(id, Objects.requireNonNull(remoteObject));
            this.localObjects.put(id, remoteObject);
        }
        return (T)remoteObject;
    }

    protected <P> P send(String method, @Nullable RpcRequest body, Class<P> responseType) {
        this.checkLiveness();
        try {
            CompletableFuture future = this.jsonRpc.send(JsonRpcRequest.newRequest((String)method, (Object)body));
            long totalTimeoutMs = this.timeout.toMillis();
            long checkIntervalMs = 500L;
            for (long elapsedMs = 0L; elapsedMs < totalTimeoutMs; elapsedMs += checkIntervalMs) {
                try {
                    return (P)((JsonRpcSuccess)future.get(checkIntervalMs, TimeUnit.MILLISECONDS)).getResult(responseType);
                }
                catch (TimeoutException e) {
                    this.checkLiveness();
                    continue;
                }
            }
            throw new RuntimeException("Request timed out after " + this.timeout.getSeconds() + " seconds");
        }
        catch (RuntimeException e) {
            this.checkLiveness();
            throw e;
        }
        catch (InterruptedException | ExecutionException e) {
            this.checkLiveness();
            throw new RuntimeException(e);
        }
    }

    private void checkLiveness() {
        RuntimeException livenessProblem = this.livenessCheck.get();
        if (livenessProblem != null) {
            throw livenessProblem;
        }
    }

    @VisibleForTesting
    Cursor getCursor(@Nullable List<String> cursorIds, @Nullable String sourceFileType) {
        Cursor cursor = new Cursor(null, "root");
        if (cursorIds != null) {
            for (int i = cursorIds.size() - 1; i >= 0; --i) {
                String cursorId = cursorIds.get(i);
                Object cursorObject = this.getObject(cursorId, sourceFileType);
                this.remoteObjects.put(cursorId, cursorObject);
                cursor = new Cursor(cursor, cursorObject);
            }
        }
        return cursor;
    }
}

