/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.openrewrite.Recipe;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleReader;
import org.openrewrite.marketplace.RecipeBundleResolver;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class YamlRecipeBundleReader
implements RecipeBundleReader {
    private final RecipeBundle bundle;
    private final YamlResourceLoader yamlLoader;

    public YamlRecipeBundleReader(RecipeBundle bundle, InputStream yamlLoader, URI source, Properties properties, RecipeMarketplace marketplace, Collection<RecipeBundleResolver> resolvers) {
        this.yamlLoader = new YamlResourceLoader(yamlLoader, source, properties, marketplace, resolvers);
        this.bundle = bundle;
    }

    @Override
    public RecipeMarketplace read() {
        Environment env = Environment.builder().scanYamlResources().build();
        RecipeMarketplace marketplace = new RecipeMarketplace();
        for (RecipeDescriptor descriptor : this.yamlLoader.listRecipeDescriptors()) {
            marketplace.install(RecipeListing.fromDescriptor(descriptor, this.bundle), descriptor.inferCategoriesFromName(env));
        }
        return marketplace;
    }

    @Override
    public RecipeDescriptor describe(RecipeListing listing) {
        return this.prepare(listing, Collections.emptyMap()).getDescriptor();
    }

    @Override
    public Recipe prepare(RecipeListing listing, Map<String, Object> options) {
        return new Environment(Collections.singleton(this.yamlLoader)).activateRecipes(listing.getName());
    }

    @Override
    @Generated
    public RecipeBundle getBundle() {
        return this.bundle;
    }
}

