/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.util.HashSet;
import org.openrewrite.Validated;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeMarketplaceCompletenessValidator {
    public Validated<RecipeMarketplace> validate(RecipeMarketplace csv, Environment env) {
        Validated<RecipeMarketplace> validation = Validated.none();
        HashSet<String> csvRecipeNames = new HashSet<String>();
        for (RecipeListing recipe : csv.getAllRecipes()) {
            csvRecipeNames.add(recipe.getName());
        }
        HashSet<String> jarRecipeNames = new HashSet<String>();
        for (RecipeDescriptor descriptor : env.listRecipeDescriptors()) {
            jarRecipeNames.add(descriptor.getName());
        }
        for (String csvRecipeName : csvRecipeNames) {
            if (jarRecipeNames.contains(csvRecipeName)) continue;
            validation = validation.and(Validated.invalid(csvRecipeName, csvRecipeName, "Recipe listed in CSV must exist in the environment; remove this entry from `recipes.csv` or add the recipe to the environment."));
        }
        for (String envRecipeName : jarRecipeNames) {
            if (csvRecipeNames.contains(envRecipeName)) continue;
            validation = validation.and(Validated.invalid(envRecipeName, envRecipeName, "Recipe exists in environment but is not listed in CSV; run `./gradlew recipeCsvGenerate` to update `recipes.csv`."));
        }
        return validation;
    }
}

