/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;
import org.openrewrite.NlsRewrite;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleReader;
import org.openrewrite.marketplace.RecipeListing;

@Incubating(since="8.66.0")
public class RecipeMarketplace {
    private final Category root = new Category("Root", "This is the root of all categories. When displaying the category hierarchy of a marketplace, this is typically not shown.");

    public @Nullable RecipeListing findRecipe(String name) {
        return this.root.findRecipe(name);
    }

    public Set<RecipeListing> getAllRecipes() {
        return this.root.getAllRecipes();
    }

    public List<Category> getCategories() {
        return this.root.getCategories();
    }

    public void install(RecipeListing recipe, List<CategoryDescriptor> categoryPath) {
        this.root.install(recipe, categoryPath);
    }

    public Set<RecipeListing> install(RecipeBundleReader bundleReader) {
        RecipeMarketplace marketplace = bundleReader.read();
        RecipeBundle bundle = bundleReader.getBundle();
        this.uninstall(bundle.getPackageEcosystem(), bundle.getPackageName());
        this.root.merge(marketplace.getRoot());
        return marketplace.getAllRecipes();
    }

    public void uninstall(String packageEcosystem, String packageName) {
        this.root.uninstall(packageEcosystem, packageName);
    }

    @Generated
    public Category getRoot() {
        return this.root;
    }

    public class Category {
        private final @NlsRewrite.DisplayName String displayName;
        private final @NlsRewrite.DisplayName String description;
        private final List<Category> categories = new ArrayList<Category>();
        private final List<RecipeListing> recipes = new ArrayList<RecipeListing>();

        public void merge(Category category) {
            for (RecipeListing recipe : category.recipes) {
                this.recipes.remove(recipe);
                this.recipes.add(recipe.withMarketplace(RecipeMarketplace.this));
            }
            for (Category subCategory : category.categories) {
                Category existingSubCategory = null;
                for (Category c : this.categories) {
                    if (!c.getDisplayName().equals(subCategory.getDisplayName())) continue;
                    existingSubCategory = c;
                    break;
                }
                if (existingSubCategory != null) {
                    existingSubCategory.merge(subCategory);
                    continue;
                }
                this.categories.add(subCategory);
            }
        }

        public void uninstall(String packageEcosystem, String packageName) {
            this.recipes.removeIf(r -> r.getBundle().getPackageName().equals(packageName) && r.getBundle().getPackageEcosystem().equals(packageEcosystem));
            for (Category category : this.categories) {
                category.uninstall(packageEcosystem, packageName);
            }
        }

        public @Nullable RecipeListing findRecipe(String name) {
            for (RecipeListing recipe : this.recipes) {
                if (!recipe.getName().equals(name)) continue;
                return recipe;
            }
            for (Category category : this.categories) {
                RecipeListing rd = category.findRecipe(name);
                if (rd == null) continue;
                return rd;
            }
            return null;
        }

        public Set<RecipeListing> getAllRecipes() {
            TreeSet<RecipeListing> recipes = new TreeSet<RecipeListing>();
            this.getAllRecipesRecursive(recipes);
            return recipes;
        }

        private void getAllRecipesRecursive(Set<RecipeListing> recipes) {
            recipes.addAll(this.recipes);
            for (Category category : this.categories) {
                category.getAllRecipesRecursive(recipes);
            }
        }

        public void install(RecipeListing recipe, List<CategoryDescriptor> categoryPath) {
            recipe = recipe.withMarketplace(RecipeMarketplace.this);
            if (categoryPath.isEmpty()) {
                this.recipes.add(recipe);
                return;
            }
            CategoryDescriptor firstCategory = categoryPath.get(0);
            Category targetCategory = this.findOrCreateCategory(firstCategory);
            targetCategory.install(recipe, categoryPath.subList(1, categoryPath.size()));
        }

        private Category findOrCreateCategory(CategoryDescriptor categoryDescriptor) {
            for (Category category : this.categories) {
                if (!category.getDisplayName().equals(categoryDescriptor.getDisplayName())) continue;
                return category;
            }
            Category newCategory = new Category(categoryDescriptor.getDisplayName(), categoryDescriptor.getDescription());
            this.categories.add(newCategory);
            return newCategory;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public List<Category> getCategories() {
            return this.categories;
        }

        @Generated
        public List<RecipeListing> getRecipes() {
            return this.recipes;
        }

        @Generated
        public Category(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }
    }
}

