/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jgit.attributes.AttributesNodeProvider;
import org.openrewrite.jgit.diff.DiffEntry;
import org.openrewrite.jgit.diff.DiffFormatter;
import org.openrewrite.jgit.diff.RawTextComparator;
import org.openrewrite.jgit.internal.storage.dfs.DfsRepositoryDescription;
import org.openrewrite.jgit.internal.storage.dfs.InMemoryRepository;
import org.openrewrite.jgit.lib.AbbreviatedObjectId;
import org.openrewrite.jgit.lib.AnyObjectId;
import org.openrewrite.jgit.lib.BaseRepositoryBuilder;
import org.openrewrite.jgit.lib.FileMode;
import org.openrewrite.jgit.lib.ObjectDatabase;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectInserter;
import org.openrewrite.jgit.lib.ObjectLoader;
import org.openrewrite.jgit.lib.ObjectReader;
import org.openrewrite.jgit.lib.RefDatabase;
import org.openrewrite.jgit.lib.ReflogReader;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.lib.StoredConfig;
import org.openrewrite.marker.GitTreeEntry;
import org.openrewrite.quark.Quark;

public class InMemoryDiffEntry
extends DiffEntry
implements AutoCloseable {
    static final AbbreviatedObjectId A_ZERO = AbbreviatedObjectId.fromObjectId((AnyObjectId)ObjectId.zeroId());
    private final VirtualInMemoryRepository repo;
    private final Set<Recipe> recipesThatMadeChanges;
    private final boolean binaryPatch;

    public InMemoryDiffEntry(@org.jspecify.annotations.Nullable Path originalFilePath, @org.jspecify.annotations.Nullable Path filePath, @org.jspecify.annotations.Nullable Path relativeTo, String oldSource, String newSource, Set<Recipe> recipesThatMadeChanges) {
        this(originalFilePath, filePath, relativeTo, oldSource, newSource, recipesThatMadeChanges, FileMode.REGULAR_FILE, FileMode.REGULAR_FILE);
    }

    public InMemoryDiffEntry(@org.jspecify.annotations.Nullable Path originalFilePath, @org.jspecify.annotations.Nullable Path filePath, @org.jspecify.annotations.Nullable Path relativeTo, String oldSource, String newSource, Set<Recipe> recipesThatMadeChanges, FileMode oldMode, FileMode newMode) {
        this(originalFilePath, filePath, relativeTo, oldSource.getBytes(StandardCharsets.UTF_8), newSource.getBytes(StandardCharsets.UTF_8), recipesThatMadeChanges, oldMode, newMode, false);
    }

    @Incubating(since="8.69.0")
    public InMemoryDiffEntry(@org.jspecify.annotations.Nullable SourceFile before, @org.jspecify.annotations.Nullable SourceFile after, @org.jspecify.annotations.Nullable Path relativeTo, @org.jspecify.annotations.Nullable PrintOutputCapture.MarkerPrinter markerPrinter, Set<Recipe> recipesThatMadeChanges, boolean binaryPatch) {
        if (before == null && after == null) {
            throw new NullPointerException("before and after can't be null");
        }
        this.recipesThatMadeChanges = recipesThatMadeChanges;
        this.binaryPatch = binaryPatch;
        try {
            this.repo = new VirtualInMemoryRepository((InMemoryRepository.Builder)new InMemoryRepository.Builder().setRepositoryDescription(new DfsRepositoryDescription()));
            try (VirtualObjectDatabase database = this.repo.getObjectDatabase();
                 ObjectInserter inserter = this.repo.getObjectDatabase().newInserter();){
                if (before == null) {
                    this.oldId = A_ZERO;
                    this.oldMode = FileMode.MISSING;
                    this.oldPath = "/dev/null";
                } else {
                    Optional<GitTreeEntry> maybeGitTreeEntry = before.getMarkers().findFirst(GitTreeEntry.class);
                    if (maybeGitTreeEntry.isPresent()) {
                        GitTreeEntry entry2 = maybeGitTreeEntry.get();
                        this.oldId = database.insertVirtual(ObjectId.fromString((String)entry2.getObjectId()), InMemoryDiffEntry.printAllAsBytes(before, markerPrinter)).abbreviate(40);
                        this.oldMode = FileMode.fromBits((int)entry2.getFileMode());
                    } else {
                        this.oldId = inserter.insert(3, InMemoryDiffEntry.printAllAsBytes(before, markerPrinter)).abbreviate(40);
                        this.oldMode = before.getFileAttributes() != null && before.getFileAttributes().isExecutable() ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE;
                    }
                    this.oldPath = (relativeTo == null ? before.getSourcePath() : relativeTo.relativize(before.getSourcePath())).toString().replace("\\", "/");
                }
                if (after == null) {
                    this.newId = A_ZERO;
                    this.newMode = FileMode.MISSING;
                    this.newPath = "/dev/null";
                } else {
                    this.newId = inserter.insert(3, InMemoryDiffEntry.printAllAsBytes(after, markerPrinter)).abbreviate(40);
                    this.newMode = after.getMarkers().findFirst(GitTreeEntry.class).map(entry -> FileMode.fromBits((int)entry.getFileMode())).orElseGet(() -> after.getFileAttributes() != null && after.getFileAttributes().isExecutable() ? FileMode.EXECUTABLE_FILE : FileMode.REGULAR_FILE);
                    this.newPath = (relativeTo == null ? after.getSourcePath() : relativeTo.relativize(after.getSourcePath())).toString().replace("\\", "/");
                }
                inserter.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.changeType = this.oldMode == FileMode.MISSING && this.newMode != FileMode.MISSING ? DiffEntry.ChangeType.ADD : (this.oldMode != FileMode.MISSING && this.newMode == FileMode.MISSING ? DiffEntry.ChangeType.DELETE : (!this.oldPath.equals(this.newPath) ? DiffEntry.ChangeType.RENAME : DiffEntry.ChangeType.MODIFY));
    }

    public InMemoryDiffEntry(@org.jspecify.annotations.Nullable Path originalFilePath, @org.jspecify.annotations.Nullable Path filePath, @org.jspecify.annotations.Nullable Path relativeTo, byte[] oldSource, byte[] newSource, Set<Recipe> recipesThatMadeChanges, FileMode oldMode, FileMode newMode, boolean binaryPatch) {
        this.recipesThatMadeChanges = recipesThatMadeChanges;
        this.binaryPatch = binaryPatch;
        try {
            this.repo = new VirtualInMemoryRepository((InMemoryRepository.Builder)new InMemoryRepository.Builder().setRepositoryDescription(new DfsRepositoryDescription()));
            try (ObjectInserter inserter = this.repo.getObjectDatabase().newInserter();){
                if (originalFilePath != null) {
                    this.oldId = inserter.insert(3, oldSource).abbreviate(40);
                    this.oldMode = oldMode;
                    this.oldPath = (relativeTo == null ? originalFilePath : relativeTo.relativize(originalFilePath)).toString().replace("\\", "/");
                } else {
                    this.oldId = A_ZERO;
                    this.oldMode = FileMode.MISSING;
                    this.oldPath = "/dev/null";
                }
                if (filePath != null) {
                    this.newId = inserter.insert(3, newSource).abbreviate(40);
                    this.newMode = newMode;
                    this.newPath = (relativeTo == null ? filePath : relativeTo.relativize(filePath)).toString().replace("\\", "/");
                } else {
                    this.newId = A_ZERO;
                    this.newMode = FileMode.MISSING;
                    this.newPath = "/dev/null";
                }
                inserter.flush();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.changeType = this.oldMode == FileMode.MISSING && this.newMode != FileMode.MISSING ? DiffEntry.ChangeType.ADD : (this.oldMode != FileMode.MISSING && this.newMode == FileMode.MISSING ? DiffEntry.ChangeType.DELETE : (!this.oldPath.equals(this.newPath) ? DiffEntry.ChangeType.RENAME : DiffEntry.ChangeType.MODIFY));
    }

    public String getDiff() {
        return this.getDiff(false);
    }

    public String getDiff(@org.jspecify.annotations.Nullable Boolean ignoreAllWhitespace) {
        if (ignoreAllWhitespace == null) {
            ignoreAllWhitespace = false;
        }
        if (this.oldId.equals((Object)this.newId) && this.oldPath.equals(this.newPath)) {
            return "";
        }
        ByteArrayOutputStream patch = new ByteArrayOutputStream();
        try (DiffFormatter formatter = new DiffFormatter((OutputStream)patch);){
            formatter.setDiffComparator(ignoreAllWhitespace != false ? RawTextComparator.WS_IGNORE_ALL : RawTextComparator.DEFAULT);
            formatter.setRepository((Repository)this.repo);
            formatter.setBinary(this.binaryPatch);
            formatter.format((DiffEntry)this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        String diff = patch.toString();
        AtomicBoolean addedComment = new AtomicBoolean(false);
        return Arrays.stream(diff.split("\n", -1)).map(l -> {
            if (!addedComment.get() && l.startsWith("@@") && l.endsWith("@@")) {
                addedComment.set(true);
                LinkedHashSet<String> sortedRecipeNames = new LinkedHashSet<String>();
                for (Recipe recipesThatMadeChange : this.recipesThatMadeChanges) {
                    sortedRecipeNames.add(recipesThatMadeChange.getName());
                }
                StringJoiner joinedRecipeNames = new StringJoiner(", ", " ", "");
                for (String name : sortedRecipeNames) {
                    joinedRecipeNames.add(name);
                }
                return l + joinedRecipeNames;
            }
            return l;
        }).collect(Collectors.joining("\n"));
    }

    @Override
    public void close() {
        this.repo.close();
    }

    private static byte[] printAllAsBytes(@org.jspecify.annotations.Nullable SourceFile sourceFile, @org.jspecify.annotations.Nullable PrintOutputCapture.MarkerPrinter markerPrinter) {
        if (sourceFile == null || sourceFile instanceof Quark) {
            return new byte[0];
        }
        PrintOutputCapture<Integer> out = markerPrinter == null ? new PrintOutputCapture<Integer>(0) : new PrintOutputCapture<Integer>(0, markerPrinter);
        Charset charset = sourceFile.getCharset() == null ? StandardCharsets.UTF_8 : sourceFile.getCharset();
        return sourceFile.printAll(out).getBytes(charset);
    }

    private static final class VirtualInMemoryRepository
    extends Repository {
        private final InMemoryRepository repo;
        private final VirtualObjectDatabase objdb;

        public VirtualInMemoryRepository(InMemoryRepository.Builder builder) throws IOException {
            super((BaseRepositoryBuilder)builder);
            this.repo = builder.build();
            this.objdb = new VirtualObjectDatabase((ObjectDatabase)this.repo.getObjectDatabase());
        }

        public void create(boolean bare) throws IOException {
            this.repo.create(bare);
        }

        public String getIdentifier() {
            return this.repo.getIdentifier();
        }

        public VirtualObjectDatabase getObjectDatabase() {
            return this.objdb;
        }

        public RefDatabase getRefDatabase() {
            return this.repo.getRefDatabase();
        }

        public StoredConfig getConfig() {
            return this.repo.getConfig();
        }

        public AttributesNodeProvider createAttributesNodeProvider() {
            return this.repo.createAttributesNodeProvider();
        }

        public void scanForRepoChanges() throws IOException {
            this.repo.scanForRepoChanges();
        }

        public void notifyIndexChanged(boolean internal) {
            this.repo.notifyIndexChanged(internal);
        }

        public ReflogReader getReflogReader(String refName) throws IOException {
            return this.repo.getReflogReader(refName);
        }

        @Generated
        public InMemoryRepository getRepo() {
            return this.repo;
        }

        @Generated
        public VirtualObjectDatabase getObjdb() {
            return this.objdb;
        }

        @NonNull
        @Generated
        public String toString() {
            return "InMemoryDiffEntry.VirtualInMemoryRepository(repo=" + this.getRepo() + ", objdb=" + this.getObjdb() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VirtualInMemoryRepository)) {
                return false;
            }
            VirtualInMemoryRepository other = (VirtualInMemoryRepository)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            InMemoryRepository this$repo = this.getRepo();
            InMemoryRepository other$repo = other.getRepo();
            if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
                return false;
            }
            VirtualObjectDatabase this$objdb = this.getObjdb();
            VirtualObjectDatabase other$objdb = other.getObjdb();
            return !(this$objdb == null ? other$objdb != null : !((Object)this$objdb).equals(other$objdb));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof VirtualInMemoryRepository;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            InMemoryRepository $repo = this.getRepo();
            result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
            VirtualObjectDatabase $objdb = this.getObjdb();
            result = result * 59 + ($objdb == null ? 43 : ((Object)$objdb).hashCode());
            return result;
        }
    }

    private static final class VirtualObjectDatabase
    extends ObjectDatabase
    implements AutoCloseable {
        private final ObjectDatabase delegate;
        private final Map<ObjectId, byte[]> virtualObjects = new HashMap<ObjectId, byte[]>();

        public ObjectId insertVirtual(ObjectId id, byte[] content) {
            this.virtualObjects.put(id, content);
            return id;
        }

        public ObjectInserter newInserter() {
            return this.delegate.newInserter();
        }

        public VirtualObjectReader newReader() {
            return new VirtualObjectReader(this.virtualObjects, this.delegate.newReader());
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Generated
        public VirtualObjectDatabase(ObjectDatabase delegate) {
            this.delegate = delegate;
        }

        @Generated
        public ObjectDatabase getDelegate() {
            return this.delegate;
        }

        @Generated
        public Map<ObjectId, byte[]> getVirtualObjects() {
            return this.virtualObjects;
        }

        @NonNull
        @Generated
        public String toString() {
            return "InMemoryDiffEntry.VirtualObjectDatabase(delegate=" + this.getDelegate() + ", virtualObjects=" + this.getVirtualObjects() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VirtualObjectDatabase)) {
                return false;
            }
            VirtualObjectDatabase other = (VirtualObjectDatabase)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ObjectDatabase this$delegate = this.getDelegate();
            ObjectDatabase other$delegate = other.getDelegate();
            if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
                return false;
            }
            Map<ObjectId, byte[]> this$virtualObjects = this.getVirtualObjects();
            Map<ObjectId, byte[]> other$virtualObjects = other.getVirtualObjects();
            return !(this$virtualObjects == null ? other$virtualObjects != null : !((Object)this$virtualObjects).equals(other$virtualObjects));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof VirtualObjectDatabase;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ObjectDatabase $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
            Map<ObjectId, byte[]> $virtualObjects = this.getVirtualObjects();
            result = result * 59 + ($virtualObjects == null ? 43 : ((Object)$virtualObjects).hashCode());
            return result;
        }
    }

    private static final class VirtualObjectReader
    extends ObjectReader {
        private final Map<ObjectId, byte[]> virtualObjects;
        private final ObjectReader delegate;

        public ObjectReader newReader() {
            return this.delegate.newReader();
        }

        public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
            return this.delegate.resolve(id);
        }

        public ObjectLoader open(AnyObjectId objectId, int typeHint) throws IOException {
            byte[] virtual = this.virtualObjects.get(objectId.toObjectId());
            if (virtual != null) {
                return new ObjectLoader.SmallObject(typeHint, virtual);
            }
            return this.delegate.open(objectId, typeHint);
        }

        public Set<ObjectId> getShallowCommits() {
            try {
                return this.delegate.getShallowCommits();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void close() {
            this.delegate.close();
        }

        @Generated
        public VirtualObjectReader(Map<ObjectId, byte[]> virtualObjects, ObjectReader delegate) {
            this.virtualObjects = virtualObjects;
            this.delegate = delegate;
        }

        @Generated
        public Map<ObjectId, byte[]> getVirtualObjects() {
            return this.virtualObjects;
        }

        @Generated
        public ObjectReader getDelegate() {
            return this.delegate;
        }

        @NonNull
        @Generated
        public String toString() {
            return "InMemoryDiffEntry.VirtualObjectReader(virtualObjects=" + this.getVirtualObjects() + ", delegate=" + this.getDelegate() + ")";
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VirtualObjectReader)) {
                return false;
            }
            VirtualObjectReader other = (VirtualObjectReader)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Map<ObjectId, byte[]> this$virtualObjects = this.getVirtualObjects();
            Map<ObjectId, byte[]> other$virtualObjects = other.getVirtualObjects();
            if (this$virtualObjects == null ? other$virtualObjects != null : !((Object)this$virtualObjects).equals(other$virtualObjects)) {
                return false;
            }
            ObjectReader this$delegate = this.getDelegate();
            ObjectReader other$delegate = other.getDelegate();
            return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof VirtualObjectReader;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<ObjectId, byte[]> $virtualObjects = this.getVirtualObjects();
            result = result * 59 + ($virtualObjects == null ? 43 : ((Object)$virtualObjects).hashCode());
            ObjectReader $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
            return result;
        }
    }
}

