/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.config.DataTableDescriptor;

public class CompositeRecipe
extends Recipe {
    private final List<Recipe> recipeList;
    final String description = "A recipe that consists of a list of other recipes.";

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public @Nullable Duration getEstimatedEffortPerOccurrence() {
        return null;
    }

    @Override
    public List<Recipe> getRecipeList() {
        return this.recipeList;
    }

    @Override
    public List<DataTableDescriptor> getDataTableDescriptors() {
        List<DataTableDescriptor> dataTableDescriptors = null;
        for (Recipe recipe : this.getRecipeList()) {
            List<DataTableDescriptor> dtds = recipe.getDataTableDescriptors();
            if (dtds.isEmpty()) continue;
            if (dataTableDescriptors == null) {
                dataTableDescriptors = new ArrayList<DataTableDescriptor>();
            }
            for (DataTableDescriptor dtd : dtds) {
                if (dataTableDescriptors.contains(dtd)) continue;
                dataTableDescriptors.add(dtd);
            }
        }
        return dataTableDescriptors == null ? super.getDataTableDescriptors() : dataTableDescriptors;
    }

    @Generated
    public CompositeRecipe(List<Recipe> recipeList) {
        this.recipeList = recipeList;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }
}

