/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.nio.file.PathMatcher;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class RenameFile
extends Recipe {
    @Option(displayName="File matcher", description="Matching files will be renamed. This is a glob expression.", example="**/application-*.yml")
    private final String fileMatcher;
    @Option(displayName="The renamed file name", description="Just the file name without the folder path that precedes it.", example="application.yml")
    private final String fileName;
    private final String displayName = "Rename a file";
    private final String description = "Rename a file while keeping it in the same directory.";

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @org.jspecify.annotations.Nullable Tree visit(@org.jspecify.annotations.Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile;
                Path sourcePath;
                PathMatcher pathMatcher;
                if (tree instanceof SourceFile && (pathMatcher = (sourcePath = (sourceFile = (SourceFile)tree).getSourcePath()).getFileSystem().getPathMatcher("glob:" + RenameFile.this.fileMatcher)).matches(sourcePath)) {
                    return ((SourceFile)tree).withSourcePath(sourcePath.resolveSibling(RenameFile.this.fileName).normalize());
                }
                return super.visit(tree, ctx);
            }
        };
    }

    @Generated
    public RenameFile(String fileMatcher, String fileName) {
        this.fileMatcher = fileMatcher;
        this.fileName = fileName;
    }

    @Generated
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RenameFile(fileMatcher=" + this.getFileMatcher() + ", fileName=" + this.getFileName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenameFile)) {
            return false;
        }
        RenameFile other = (RenameFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        if (this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RenameFile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

