/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.openrewrite.Changeset;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.config.ColumnDescriptor;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class RecipeRun {
    private final Changeset changeset;
    private final Map<DataTable<?>, List<?>> dataTables;

    public @org.jspecify.annotations.Nullable DataTable<?> getDataTable(String name) {
        for (DataTable<?> dataTable : this.dataTables.keySet()) {
            if (!dataTable.getName().equals(name)) continue;
            return dataTable;
        }
        return null;
    }

    public <E> List<E> getDataTableRows(String name) {
        ArrayList results = new ArrayList();
        for (Map.Entry<DataTable<?>, List<?>> dataTableAndRows : this.dataTables.entrySet()) {
            if (!dataTableAndRows.getKey().getName().equals(name)) continue;
            results.addAll(dataTableAndRows.getValue());
        }
        return results;
    }

    public void exportDatatablesToCsv(Path filePath, ExecutionContext ctx) {
        try {
            Files.createDirectories(filePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            ctx.getOnError().accept(e);
        }
        HashSet<File> createdFiles = new HashSet<File>();
        for (Map.Entry<DataTable<?>, List<?>> entry : this.dataTables.entrySet()) {
            DataTable<?> dataTable = entry.getKey();
            List<?> rows = entry.getValue();
            File csv = filePath.resolve(dataTable.getName() + ".csv").toFile();
            boolean added = createdFiles.add(csv);
            RecipeRun.exportCsv(dataTable, csv, added, rows, ctx);
        }
    }

    private static void exportCsv(DataTable<?> dataTable, File csv, boolean writeHeader, List<?> rows, ExecutionContext ctx) {
        try (PrintWriter printWriter = new PrintWriter(new FileOutputStream(csv, !writeHeader));){
            Consumer<String> output = printWriter::println;
            DataTableDescriptor descriptor = RecipeIntrospectionUtils.dataTableDescriptorFromDataTable(dataTable);
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<String> fieldTitles = new ArrayList<String>();
            ArrayList<String> fieldDescriptions = new ArrayList<String>();
            for (ColumnDescriptor columnDescriptor : descriptor.getColumns()) {
                fieldNames.add(columnDescriptor.getName());
                fieldTitles.add(RecipeRun.formatForCsv(columnDescriptor.getDisplayName()));
                fieldDescriptions.add(RecipeRun.formatForCsv(columnDescriptor.getDescription()));
            }
            if (writeHeader) {
                output.accept(String.join((CharSequence)",", fieldTitles));
                output.accept(String.join((CharSequence)",", fieldDescriptions));
            }
            for (ColumnDescriptor row : rows) {
                ArrayList<String> rowValues = new ArrayList<String>();
                for (String fieldName : fieldNames) {
                    try {
                        Field field = row.getClass().getDeclaredField(fieldName);
                        field.setAccessible(true);
                        rowValues.add(RecipeRun.formatForCsv(field.get(row)));
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        ctx.getOnError().accept(e);
                    }
                }
                output.accept(String.join((CharSequence)",", rowValues));
            }
        }
        catch (FileNotFoundException e) {
            ctx.getOnError().accept(e);
        }
    }

    private static String formatForCsv(@org.jspecify.annotations.Nullable Object data) {
        if (data != null) {
            return StringEscapeUtils.escapeCsv((String)String.valueOf(data));
        }
        return "\"\"";
    }

    @Generated
    public RecipeRun(Changeset changeset, Map<DataTable<?>, List<?>> dataTables) {
        this.changeset = changeset;
        this.dataTables = dataTables;
    }

    @Generated
    public Changeset getChangeset() {
        return this.changeset;
    }

    @Generated
    public Map<DataTable<?>, List<?>> getDataTables() {
        return this.dataTables;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeRun)) {
            return false;
        }
        RecipeRun other = (RecipeRun)o;
        Changeset this$changeset = this.getChangeset();
        Changeset other$changeset = other.getChangeset();
        if (this$changeset == null ? other$changeset != null : !this$changeset.equals(other$changeset)) {
            return false;
        }
        Map<DataTable<?>, List<?>> this$dataTables = this.getDataTables();
        Map<DataTable<?>, List<?>> other$dataTables = other.getDataTables();
        return !(this$dataTables == null ? other$dataTables != null : !((Object)this$dataTables).equals(other$dataTables));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Changeset $changeset = this.getChangeset();
        result = result * 59 + ($changeset == null ? 43 : $changeset.hashCode());
        Map<DataTable<?>, List<?>> $dataTables = this.getDataTables();
        result = result * 59 + ($dataTables == null ? 43 : ((Object)$dataTables).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RecipeRun(changeset=" + this.getChangeset() + ", dataTables=" + this.getDataTables() + ")";
    }

    @NonNull
    @Generated
    public RecipeRun withChangeset(Changeset changeset) {
        return this.changeset == changeset ? this : new RecipeRun(changeset, this.dataTables);
    }

    @NonNull
    @Generated
    public RecipeRun withDataTables(Map<DataTable<?>, List<?>> dataTables) {
        return this.dataTables == dataTables ? this : new RecipeRun(this.changeset, dataTables);
    }
}

