/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.SearchResult;

public final class IsInRepository
extends Recipe {
    private final String displayName = "Is in repository";
    private final String description = "A search recipe which marks files that are in a repository with one of the supplied names. Intended for use as a precondition for other recipes being run over many different repositories.";
    @Option(displayName="Allowed repositories", description="The names of the repositories that are allowed to be searched. Determines repository name according to git metadata recorded in the `GitProvenance` marker.", example="rewrite")
    private final Set<String> allowedRepositories;

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @org.jspecify.annotations.Nullable Tree visit(@org.jspecify.annotations.Nullable Tree tree, ExecutionContext ctx) {
                if (tree == null) {
                    return null;
                }
                Optional<GitProvenance> maybeGp = tree.getMarkers().findFirst(GitProvenance.class);
                if (maybeGp.isPresent()) {
                    GitProvenance gp = maybeGp.get();
                    if (IsInRepository.this.allowedRepositories.contains(gp.getRepositoryName())) {
                        return SearchResult.found(tree);
                    }
                }
                return tree;
            }
        };
    }

    @Generated
    public IsInRepository(Set<String> allowedRepositories) {
        this.allowedRepositories = allowedRepositories;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getAllowedRepositories() {
        return this.allowedRepositories;
    }

    @NonNull
    @Generated
    public String toString() {
        return "IsInRepository(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", allowedRepositories=" + this.getAllowedRepositories() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IsInRepository)) {
            return false;
        }
        IsInRepository other = (IsInRepository)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$allowedRepositories = this.getAllowedRepositories();
        Set<String> other$allowedRepositories = other.getAllowedRepositories();
        return !(this$allowedRepositories == null ? other$allowedRepositories != null : !((Object)this$allowedRepositories).equals(other$allowedRepositories));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof IsInRepository;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $allowedRepositories = this.getAllowedRepositories();
        result = result * 59 + ($allowedRepositories == null ? 43 : ((Object)$allowedRepositories).hashCode());
        return result;
    }
}

