/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Objects;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.quark.Quark;

public final class FindQuarks
extends Recipe {
    private final String displayName = "Find instances of type `Quark`";
    private final String description = "`Quark` source files are pointers to the existence of a file without capturing any of the contents of the file.";

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@org.jspecify.annotations.Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile instanceof Quark) {
                    return SearchResult.found(sourceFile);
                }
                return sourceFile;
            }
        };
    }

    @Generated
    public FindQuarks() {
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindQuarks(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindQuarks)) {
            return false;
        }
        FindQuarks other = (FindQuarks)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindQuarks;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

