/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.time.ZoneOffset;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.LstProvenance;
import org.openrewrite.table.LstProvenanceTable;

public final class FindLstProvenance
extends ScanningRecipe<Accumulator> {
    private final String displayName = "Find LST provenance";
    private final String description = "Produces a data table showing what versions of OpenRewrite/Moderne tooling was used to produce a given LST.";
    private final transient LstProvenanceTable provenanceTable = new LstProvenanceTable(this);

    @Override
    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                if (acc.foundLstProvenance) {
                    return tree;
                }
                LstProvenance lstProvenance = tree.getMarkers().findFirst(LstProvenance.class).orElse(null);
                if (lstProvenance == null) {
                    return tree;
                }
                FindLstProvenance.this.provenanceTable.insertRow(ctx, new LstProvenanceTable.Row(lstProvenance.getBuildToolType(), lstProvenance.getBuildToolVersion(), lstProvenance.getLstSerializerVersion(), lstProvenance.getTimestampUtc() == null ? null : Long.valueOf(lstProvenance.getTimestampUtc().toEpochMilli()), lstProvenance.getTimestampUtc() == null ? null : lstProvenance.getTimestampUtc().atZone(ZoneOffset.UTC).toString()));
                acc.foundLstProvenance = true;
                return tree;
            }
        };
    }

    @Generated
    public FindLstProvenance() {
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public LstProvenanceTable getProvenanceTable() {
        return this.provenanceTable;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindLstProvenance(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", provenanceTable=" + this.getProvenanceTable() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindLstProvenance)) {
            return false;
        }
        FindLstProvenance other = (FindLstProvenance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindLstProvenance;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static class Accumulator {
        boolean foundLstProvenance;
    }
}

