/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.text.PlainTextVisitor;

public final class AddToGitignore
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="Entries", description="Multiline text containing gitignore entries to add, each on a separate line. Comments and blank lines are preserved.", example="*.tmp\n.DS_Store\ntarget/")
    private final String entries;
    @Option(displayName="File pattern", description="A glob pattern to match `.gitignore` files to update. Defaults to only the root `.gitignore` file. Use `**/.gitignore` to update all `.gitignore` files in the repository, or specify a specific path like `src/.gitignore`.", required=false, example=".gitignore")
    private final @org.jspecify.annotations.Nullable String filePattern;
    private final String displayName = "Add entries to `.gitignore`";
    private final String description = "Adds entries to the project's `.gitignore` file. If no `.gitignore` file exists, one will be created. Existing entries that match will not be duplicated.";

    @Override
    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(true);
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean shouldCreate) {
        final String pattern = this.getEffectiveFilePattern();
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @org.jspecify.annotations.Nullable Tree visit(@org.jspecify.annotations.Nullable Tree tree, ExecutionContext ctx) {
                String sourcePath;
                if (tree instanceof SourceFile && (sourcePath = PathUtils.separatorsToUnix(((SourceFile)tree).getSourcePath().toString())).endsWith(".gitignore") && this.shouldNotCreate(sourcePath, pattern)) {
                    shouldCreate.set(false);
                }
                return tree;
            }

            private boolean shouldNotCreate(String sourcePath, String pattern2) {
                return pattern2.contains("*") || pattern2.contains("?") || sourcePath.equals(pattern2);
            }
        };
    }

    @Override
    public Collection<? extends SourceFile> generate(AtomicBoolean shouldCreate, ExecutionContext ctx) {
        if (shouldCreate.get()) {
            String pattern = this.getEffectiveFilePattern();
            String path = this.patternToPathToCreate(pattern);
            return PlainTextParser.builder().build().parse("").map(text -> text.withSourcePath(Paths.get(path, new String[0]))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String getEffectiveFilePattern() {
        return StringUtils.isBlank(this.filePattern) ? ".gitignore" : this.filePattern;
    }

    private String patternToPathToCreate(String pattern) {
        if (!pattern.contains("*") && !pattern.contains("?")) {
            return pattern;
        }
        if ("**/.gitignore".equals(pattern)) {
            return ".gitignore";
        }
        if (pattern.endsWith("/.gitignore")) {
            return pattern;
        }
        return ".gitignore";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean shouldCreate) {
        String pattern = this.getEffectiveFilePattern();
        return Preconditions.check(new FindSourceFiles(pattern), new PlainTextVisitor<ExecutionContext>(){

            @Override
            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                return text.withText(this.mergeGitignoreEntries(text.getText(), AddToGitignore.this.entries));
            }

            private String mergeGitignoreEntries(String existing, String newEntries) {
                String separator = existing.contains("\r\n") ? "\r\n" : "\n";
                LinkedHashSet<String> existingRules = new LinkedHashSet<String>();
                LinkedHashSet<String> existingWildcardPatterns = new LinkedHashSet<String>();
                LinkedHashSet<String> existingComments = new LinkedHashSet<String>();
                ArrayList<String> existingLines = new ArrayList<String>();
                if (!StringUtils.isBlank(existing)) {
                    for (String line : existing.split("\r?\n")) {
                        existingLines.add(line);
                        String trimmed = line.trim();
                        if (StringUtils.isBlank(trimmed)) continue;
                        if (trimmed.startsWith("#")) {
                            existingComments.add(trimmed);
                            continue;
                        }
                        existingRules.add(this.normalizeRule(trimmed));
                        if (trimmed.endsWith("/")) {
                            existingWildcardPatterns.add(trimmed + "**");
                            continue;
                        }
                        if (!trimmed.contains("*")) continue;
                        existingWildcardPatterns.add(trimmed);
                    }
                }
                ArrayList<String> linesToAdd = new ArrayList<String>();
                for (String entry : newEntries.split("\r?\n")) {
                    String trimmed = entry.trim();
                    if (StringUtils.isBlank(trimmed)) continue;
                    if (trimmed.startsWith("#")) {
                        if (!existingComments.add(trimmed)) continue;
                        linesToAdd.add(entry);
                        continue;
                    }
                    if (this.isRedundantEntry(trimmed, existingWildcardPatterns) || !existingRules.add(this.normalizeRule(trimmed))) continue;
                    linesToAdd.add(entry);
                }
                if (linesToAdd.isEmpty()) {
                    return existing;
                }
                ArrayList<String> result = new ArrayList<String>(existingLines);
                if (!existingLines.isEmpty() && !StringUtils.isBlank((String)existingLines.get(existingLines.size() - 1))) {
                    result.add("");
                }
                result.addAll(linesToAdd);
                return String.join((CharSequence)separator, result);
            }

            private String normalizeRule(String rule) {
                String normalized = rule.trim();
                if (normalized.startsWith("!")) {
                    normalized = normalized.substring(1).trim();
                }
                if (normalized.endsWith("/")) {
                    normalized = normalized.substring(0, normalized.length() - 1);
                }
                if (normalized.startsWith("/")) {
                    normalized = normalized.substring(1);
                }
                return normalized;
            }

            private boolean isRedundantEntry(String entry, Set<String> existingWildcardPatterns) {
                for (String pattern : existingWildcardPatterns) {
                    if (!PathUtils.matchesGlob(entry, pattern)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Generated
    public AddToGitignore(String entries, @org.jspecify.annotations.Nullable String filePattern) {
        this.entries = entries;
        this.filePattern = filePattern;
    }

    @Generated
    public String getEntries() {
        return this.entries;
    }

    @Generated
    public @org.jspecify.annotations.Nullable String getFilePattern() {
        return this.filePattern;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddToGitignore(entries=" + this.getEntries() + ", filePattern=" + this.getFilePattern() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddToGitignore)) {
            return false;
        }
        AddToGitignore other = (AddToGitignore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$entries = this.getEntries();
        String other$entries = other.getEntries();
        if (this$entries == null ? other$entries != null : !this$entries.equals(other$entries)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        if (this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddToGitignore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : $entries.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

