/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Adopt AssertJ Float Assertions", description="Adopt AssertJ Float Assertions. Favor semantically explicit methods (e.g. `myFloat.isZero()` over `myFloat.isEqualTo(0.0f)`).")
public class AssertJFloatRules {

    @RecipeDescriptor(name="Replace `isEqualTo(1)` with `isOne()`", description="Replace `isEqualTo(1)` with `isOne()`.")
    static final class AbstractFloatAssertIsOne {
        AbstractFloatAssertIsOne() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {
            return (AbstractFloatAssert)Refaster.anyOf((Object[])new AbstractFloatAssert[]{floatAssert.isEqualTo(1.0f), floatAssert.isEqualTo(1.0f)});
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {
            return floatAssert.isOne();
        }
    }

    @RecipeDescriptor(name="Replace `isNotEqualTo(0)` with `isNotZero()`", description="Replace `isNotEqualTo(0)` with `isNotZero()`.")
    static final class AbstractFloatAssertIsNotZero {
        AbstractFloatAssertIsNotZero() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {
            return (AbstractFloatAssert)Refaster.anyOf((Object[])new AbstractFloatAssert[]{floatAssert.isNotEqualTo(0.0f), floatAssert.isNotEqualTo(0.0f)});
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {
            return floatAssert.isNotZero();
        }
    }

    @RecipeDescriptor(name="Replace `isEqualTo(0)` with `isZero()`", description="Replace `isEqualTo(0)` with `isZero()`.")
    static final class AbstractFloatAssertIsZero {
        AbstractFloatAssertIsZero() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert) {
            return (AbstractFloatAssert)Refaster.anyOf((Object[])new AbstractFloatAssert[]{floatAssert.isEqualTo(0.0f), floatAssert.isEqualTo(0.0f)});
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert) {
            return floatAssert.isZero();
        }
    }

    @RecipeDescriptor(name="Replace `isNotCloseTo` with `isNotEqualTo`", description="Replace `isNotCloseTo` with `isNotEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractFloatAssertIsNotEqualTo {
        AbstractFloatAssertIsNotEqualTo() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, float n) {
            return (AbstractFloatAssert)Refaster.anyOf((Object[])new AbstractFloatAssert[]{floatAssert.isNotCloseTo(n, Offset.offset((Number)Float.valueOf(0.0f))), floatAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0)), floatAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0)), floatAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert, float n) {
            return floatAssert.isNotEqualTo(n);
        }
    }

    @RecipeDescriptor(name="Replace `isCloseTo` with `isEqualTo`", description="Replace `isCloseTo` with `isEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractFloatAssertIsEqualTo {
        AbstractFloatAssertIsEqualTo() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, float n) {
            return (AbstractFloatAssert)Refaster.anyOf((Object[])new AbstractFloatAssert[]{floatAssert.isCloseTo(n, Offset.offset((Number)Float.valueOf(0.0f))), floatAssert.isCloseTo(n, Percentage.withPercentage((double)0.0)), floatAssert.isCloseTo(n, Percentage.withPercentage((double)0.0)), floatAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert, float n) {
            return floatAssert.isEqualTo(n);
        }
    }

    @RecipeDescriptor(name="Replace `isEqualTo` with `isCloseTo`", description="Replace `isEqualTo` with `isCloseTo` when `offset` or `percentage` is provided.")
    static final class AbstractFloatAssertIsCloseToWithOffset {
        AbstractFloatAssertIsCloseToWithOffset() {
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, float n, Offset<Float> offset) {
            return floatAssert.isEqualTo(n, offset);
        }

        AbstractFloatAssert<?> before(AbstractFloatAssert<?> floatAssert, Float n, Offset<Float> offset) {
            return floatAssert.isEqualTo(n, offset);
        }

        AbstractFloatAssert<?> after(AbstractFloatAssert<?> floatAssert, float n, Offset<Float> offset) {
            return floatAssert.isCloseTo(n, offset);
        }
    }
}

