/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class FinalizeMethodArguments
extends Recipe {
    public String getDisplayName() {
        return "Finalize method arguments";
    }

    public String getDescription() {
        return "Adds the `final` modifier keyword to method parameters.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, ExecutionContext ctx) {
                J.MethodDeclaration declarations = super.visitMethodDeclaration(methodDeclaration, (Object)ctx);
                if (FinalizeMethodArguments.isWrongKind(methodDeclaration) || FinalizeMethodArguments.this.isEmpty(declarations.getParameters()) || FinalizeMethodArguments.this.hasFinalModifiers(declarations.getParameters()) || FinalizeMethodArguments.isAbstractMethod(methodDeclaration)) {
                    return declarations;
                }
                AtomicBoolean assigned = new AtomicBoolean(false);
                methodDeclaration.getParameters().forEach(p -> this.checkIfAssigned(assigned, (Statement)p));
                if (assigned.get()) {
                    return declarations;
                }
                List parameters = ListUtils.map((List)declarations.getParameters(), x$0 -> FinalizeMethodArguments.updateParam(x$0));
                return declarations.withParameters(parameters);
            }

            private void checkIfAssigned(AtomicBoolean assigned, Statement p) {
                J.VariableDeclarations variableDeclarations;
                if (p instanceof J.VariableDeclarations && (variableDeclarations = (J.VariableDeclarations)p).getVariables().stream().anyMatch(namedVariable -> FindAssignmentReferencesToVariable.find((J)this.getCursor().getParentTreeCursor().getValue(), namedVariable).get())) {
                    assigned.set(true);
                }
            }
        };
    }

    private static boolean isWrongKind(J.MethodDeclaration methodDeclaration) {
        return Optional.ofNullable(methodDeclaration.getMethodType()).map(JavaType.Method::getDeclaringType).map(JavaType.FullyQualified::getKind).filter(arg_0 -> JavaType.FullyQualified.Kind.Interface.equals(arg_0)).isPresent();
    }

    private static boolean isAbstractMethod(J.MethodDeclaration method) {
        return method.getModifiers().stream().anyMatch(modifier -> modifier.getType() == J.Modifier.Type.Abstract);
    }

    private static Statement updateParam(Statement p) {
        J.VariableDeclarations variableDeclarations;
        if (p instanceof J.VariableDeclarations && (variableDeclarations = (J.VariableDeclarations)p).getModifiers().isEmpty()) {
            variableDeclarations = FinalizeMethodArguments.updateModifiers(variableDeclarations, !((J.VariableDeclarations)p).getLeadingAnnotations().isEmpty());
            return FinalizeMethodArguments.updateDeclarations(variableDeclarations);
        }
        return p;
    }

    private static J.VariableDeclarations updateDeclarations(J.VariableDeclarations variableDeclarations) {
        return variableDeclarations.withTypeExpression(variableDeclarations.getTypeExpression() != null ? (TypeTree)variableDeclarations.getTypeExpression().withPrefix(Space.SINGLE_SPACE) : null);
    }

    private static J.VariableDeclarations updateModifiers(J.VariableDeclarations variableDeclarations, boolean leadingAnnotations) {
        List modifiers = variableDeclarations.getModifiers();
        J.Modifier finalModifier = new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, J.Modifier.Type.Final, Collections.emptyList());
        if (leadingAnnotations) {
            finalModifier = finalModifier.withPrefix(Space.SINGLE_SPACE);
        }
        return variableDeclarations.withModifiers(ListUtils.concat((Object)finalModifier, (List)modifiers));
    }

    private boolean hasFinalModifiers(List<Statement> parameters) {
        return parameters.stream().allMatch(p -> {
            if (p instanceof J.VariableDeclarations) {
                List modifiers = ((J.VariableDeclarations)p).getModifiers();
                return !modifiers.isEmpty() && modifiers.stream().allMatch(m -> m.getType() == J.Modifier.Type.Final);
            }
            return false;
        });
    }

    private boolean isEmpty(List<Statement> parameters) {
        return parameters.size() == 1 && parameters.get(0) instanceof J.Empty;
    }

    private static final class FindAssignmentReferencesToVariable
    extends JavaIsoVisitor<AtomicBoolean> {
        private final J.VariableDeclarations.NamedVariable variable;

        static AtomicBoolean find(J subtree, J.VariableDeclarations.NamedVariable variable) {
            return (AtomicBoolean)new FindAssignmentReferencesToVariable(variable).reduce((Tree)subtree, new AtomicBoolean());
        }

        public J.Assignment visitAssignment(J.Assignment a, AtomicBoolean hasAssignment) {
            J.Identifier identifier;
            if (hasAssignment.get()) {
                return a;
            }
            J.Assignment assignment = super.visitAssignment(a, (Object)hasAssignment);
            if (assignment.getVariable() instanceof J.Identifier && (identifier = (J.Identifier)assignment.getVariable()).getSimpleName().equals(this.variable.getSimpleName())) {
                hasAssignment.set(true);
            }
            return assignment;
        }

        public J.Unary visitUnary(J.Unary unary, AtomicBoolean hasAssignment) {
            J.Identifier i;
            if (hasAssignment.get()) {
                return unary;
            }
            J.Unary u = super.visitUnary(unary, (Object)hasAssignment);
            if (u.getOperator().isModifying() && u.getExpression() instanceof J.Identifier && (i = (J.Identifier)u.getExpression()).getSimpleName().equals(this.variable.getSimpleName())) {
                hasAssignment.set(true);
            }
            return u;
        }

        public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignOp, AtomicBoolean hasAssignment) {
            J.Identifier i;
            if (hasAssignment.get()) {
                return assignOp;
            }
            J.AssignmentOperation a = super.visitAssignmentOperation(assignOp, (Object)hasAssignment);
            if (a.getVariable() instanceof J.Identifier && (i = (J.Identifier)a.getVariable()).getSimpleName().equals(this.variable.getSimpleName())) {
                hasAssignment.set(true);
            }
            return a;
        }

        @Generated
        public FindAssignmentReferencesToVariable(J.VariableDeclarations.NamedVariable variable) {
            this.variable = variable;
        }

        @Generated
        public J.VariableDeclarations.NamedVariable getVariable() {
            return this.variable;
        }

        @Generated
        public String toString() {
            return "FinalizeMethodArguments.FindAssignmentReferencesToVariable(variable=" + this.getVariable() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FindAssignmentReferencesToVariable)) {
                return false;
            }
            FindAssignmentReferencesToVariable other = (FindAssignmentReferencesToVariable)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            J.VariableDeclarations.NamedVariable this$variable = this.getVariable();
            J.VariableDeclarations.NamedVariable other$variable = other.getVariable();
            return !(this$variable == null ? other$variable != null : !this$variable.equals(other$variable));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FindAssignmentReferencesToVariable;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            J.VariableDeclarations.NamedVariable $variable = this.getVariable();
            result = result * 59 + ($variable == null ? 43 : $variable.hashCode());
            return result;
        }
    }
}

