/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.openapi.swagger;

import java.util.ArrayList;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.openapi.swagger.AnnotationUtils;

public class MigrateSwaggerDefinitionToOpenAPIDefinition
extends Recipe {
    private static final String FQN_SWAGGER_DEFINITION = "io.swagger.annotations.SwaggerDefinition";
    private static final String FQN_OPENAPI_DEFINITION = "io.swagger.v3.oas.annotations.OpenAPIDefinition";
    private static final String FQN_SERVER = "io.swagger.v3.oas.annotations.servers.Server";

    public String getDisplayName() {
        return "Migrate from `@SwaggerDefinition` to `@OpenAPIDefinition`";
    }

    public String getDescription() {
        return "Migrate from `@SwaggerDefinition` to `@OpenAPIDefinition`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(FQN_SWAGGER_DEFINITION, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final AnnotationMatcher annotationMatcher = new AnnotationMatcher("io.swagger.annotations.SwaggerDefinition");

            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation ann = super.visitAnnotation(annotation, (Object)ctx);
                if (this.annotationMatcher.matches(ann)) {
                    Map<String, Expression> args = AnnotationUtils.extractArgumentAssignedExpressions(ann);
                    StringBuilder tpl = new StringBuilder("@OpenAPIDefinition(\n");
                    ArrayList<Expression> tplArgs = new ArrayList<Expression>();
                    ArrayList<String> parts = new ArrayList<String>();
                    Expression basePath = args.get("basePath");
                    Expression host = args.get("host");
                    Expression schemes = args.get("schemes");
                    String servers = "";
                    if (basePath != null && host != null && schemes != null) {
                        tpl.append("servers = {\n");
                        if (schemes instanceof J.FieldAccess) {
                            servers = servers + "@Server(url = \"" + ((J.FieldAccess)schemes).getSimpleName().toLowerCase() + "://" + host + basePath + "\")";
                        } else if (schemes instanceof J.NewArray) {
                            for (Expression expression : ((J.NewArray)schemes).getInitializer()) {
                                if (!servers.isEmpty()) {
                                    servers = servers + ",\n";
                                }
                                String schemeName = ((J.FieldAccess)expression).getSimpleName().toLowerCase();
                                servers = servers + "@Server(url = \"" + schemeName + "://" + host + basePath + "\")";
                            }
                        }
                        servers = servers + "\n}";
                        parts.add(servers);
                    }
                    args.remove("basePath");
                    args.remove("host");
                    args.remove("schemes");
                    args.remove("produces");
                    args.remove("consumes");
                    for (Map.Entry entry : args.entrySet()) {
                        parts.add((String)entry.getKey() + " = #{any()}");
                        tplArgs.add((Expression)entry.getValue());
                    }
                    tpl.append(String.join((CharSequence)",\n", parts));
                    tpl.append("\n)");
                    ann = (J.Annotation)JavaTemplate.builder((String)tpl.toString()).imports(new String[]{MigrateSwaggerDefinitionToOpenAPIDefinition.FQN_OPENAPI_DEFINITION, MigrateSwaggerDefinitionToOpenAPIDefinition.FQN_SERVER}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"swagger-annotations"})).build().apply(this.updateCursor((Tree)ann), ann.getCoordinates().replace(), tplArgs.toArray());
                    this.maybeRemoveImport(MigrateSwaggerDefinitionToOpenAPIDefinition.FQN_SWAGGER_DEFINITION);
                    this.maybeAddImport(MigrateSwaggerDefinitionToOpenAPIDefinition.FQN_OPENAPI_DEFINITION, false);
                    this.maybeAddImport(MigrateSwaggerDefinitionToOpenAPIDefinition.FQN_SERVER, false);
                    ann = (J.Annotation)this.maybeAutoFormat((J)annotation, (J)ann, ctx);
                }
                this.doAfterVisit(new RemoveUnusedImports().getVisitor());
                return ann;
            }
        });
    }
}

