/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.logging.Level;
import org.openrewrite.java.template.RecipeDescriptor;
import org.slf4j.Logger;

@RecipeDescriptor(name="Replace JUL active Level check with corresponding SLF4J method calls", description="Replace calls to `Logger.isLoggable(Level)` with the corresponding SLF4J method calls.")
public class JulIsLoggableToIsEnabled {

    @RecipeDescriptor(name="Replace JUL `Logger.isLoggable(Level.SEVERE)` with SLF4J's `Logger.isErrorEnabled()`", description="Replace calls to `java.util.logging.Logger.isLoggable(Level.SEVERE)` with `org.slf4j.Logger.isErrorEnabled()`.")
    public static class LoggerIsLoggableLevelSevere {
        boolean before(java.util.logging.Logger logger) {
            return logger.isLoggable(Level.SEVERE);
        }

        boolean after(Logger logger) {
            return logger.isErrorEnabled();
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.isLoggable(Level.WARNING)` with SLF4J's `Logger.isWarnEnabled()`", description="Replace calls to `java.util.logging.Logger.isLoggable(Level.WARNING)` with `org.slf4j.Logger.isWarnEnabled()`.")
    public static class LoggerIsLoggableLevelWarning {
        boolean before(java.util.logging.Logger logger) {
            return logger.isLoggable(Level.WARNING);
        }

        boolean after(Logger logger) {
            return logger.isWarnEnabled();
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.isLoggable(Level.INFO)` with SLF4J's `Logger.isInfoEnabled()`", description="Replace calls to `java.util.logging.Logger.isLoggable(Level.INFO)` with `org.slf4j.Logger.isInfoEnabled()`.")
    public static class LoggerIsLoggableLevelInfo {
        boolean before(java.util.logging.Logger logger) {
            return logger.isLoggable(Level.INFO);
        }

        boolean after(Logger logger) {
            return logger.isInfoEnabled();
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.isLoggable(Level.CONFIG)` with SLF4J's `Logger.isInfoEnabled()`", description="Replace calls to `java.util.logging.Logger.isLoggable(Level.CONFIG)` with `org.slf4j.Logger.isInfoEnabled()`.")
    public static class LoggerIsLoggableLevelConfig {
        boolean before(java.util.logging.Logger logger) {
            return logger.isLoggable(Level.CONFIG);
        }

        boolean after(Logger logger) {
            return logger.isInfoEnabled();
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.isLoggable(Level.FINE)` with SLF4J's `Logger.isDebugEnabled()`", description="Replace calls to `java.util.logging.Logger.isLoggable(Level.FINE)` with `org.slf4j.Logger.isDebugEnabled()`.")
    public static class LoggerIsLoggableLevelFine {
        boolean before(java.util.logging.Logger logger) {
            return logger.isLoggable(Level.FINE);
        }

        boolean after(Logger logger) {
            return logger.isDebugEnabled();
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.isLoggable(Level.FINER)` with SLF4J's `Logger.isTraceEnabled()`", description="Replace calls to `java.util.logging.Logger.isLoggable(Level.FINER)` with `org.slf4j.Logger.isTraceEnabled()`.")
    public static class LoggerIsLoggableLevelFiner {
        boolean before(java.util.logging.Logger logger) {
            return logger.isLoggable(Level.FINER);
        }

        boolean after(Logger logger) {
            return logger.isTraceEnabled();
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.isLoggable(Level.FINEST)` with SLF4J's `Logger.isTraceEnabled`", description="Replace calls to `java.util.logging.Logger.isLoggable(Level.FINEST)` with `org.slf4j.Logger.isTraceEnabled()`.")
    public static class LoggerIsLoggableLevelFinest {
        boolean before(java.util.logging.Logger logger) {
            return logger.isLoggable(Level.FINEST);
        }

        boolean after(Logger logger) {
            return logger.isTraceEnabled();
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.isLoggable(Level.ALL)` with SLF4J's `Logger.isTraceEnabled`", description="Replace calls to `java.util.logging.Logger.isLoggable(Level.ALL)` with `org.slf4j.Logger.isTraceEnabled()`.")
    public static class LoggerIsLoggableLevelAll {
        boolean before(java.util.logging.Logger logger) {
            return logger.isLoggable(Level.ALL);
        }

        boolean after(Logger logger) {
            return logger.isTraceEnabled();
        }
    }
}

