/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.ChangeValue;
import org.openrewrite.yaml.DeleteKey;
import org.openrewrite.yaml.MergeYaml;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.search.FindKey;
import org.openrewrite.yaml.tree.Yaml;

public final class UpgradeSlackNotificationVersion2
extends Recipe {
    public String getDisplayName() {
        return "Upgrade `slackapi/slack-github-action`";
    }

    public String getDescription() {
        return "Update the Slack GitHub Action to use version 2.0.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new UpgradeSlackNotificationActionVisitor());
    }

    @Generated
    public UpgradeSlackNotificationVersion2() {
    }

    @Generated
    public String toString() {
        return "UpgradeSlackNotificationVersion2()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeSlackNotificationVersion2)) {
            return false;
        }
        UpgradeSlackNotificationVersion2 other = (UpgradeSlackNotificationVersion2)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpgradeSlackNotificationVersion2;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class UpgradeSlackNotificationActionVisitor
    extends YamlVisitor<ExecutionContext> {
        private static final String jsonPath = "$..steps[?(@.uses =~ 'slackapi/slack-github-action@v1.*')]";

        public Yaml visitDocuments(Yaml.Documents documents, ExecutionContext ctx) {
            Yaml.Documents d = documents;
            Set slackAction = FindKey.find((Yaml)documents, (String)jsonPath);
            if (slackAction.isEmpty()) {
                return documents;
            }
            Yaml slackActionFragment = (Yaml)slackAction.iterator().next();
            Set token = FindKey.find((Yaml)slackActionFragment, (String)"$.env.SLACK_BOT_TOKEN");
            Set channel = FindKey.find((Yaml)slackActionFragment, (String)"$.with.channel-id");
            Set message = FindKey.find((Yaml)slackActionFragment, (String)"$.with.slack-message");
            if (token.isEmpty() || channel.isEmpty() || message.isEmpty()) {
                return documents;
            }
            String slackToken = ((Yaml.Scalar)((Yaml.Mapping.Entry)token.iterator().next()).getValue()).getValue();
            String channelName = ((Yaml.Scalar)((Yaml.Mapping.Entry)channel.iterator().next()).getValue()).getValue();
            String messageText = ((Yaml.Scalar)((Yaml.Mapping.Entry)message.iterator().next()).getValue()).getValue();
            d = (Yaml.Documents)new MergeYaml(jsonPath, "with:\n  method: chat.postMessage\n  token: " + slackToken + "\n  payload: |\n    channel: \"" + channelName + "\"\n    text: \"" + messageText + "\"\n", Boolean.valueOf(false), null, null, null, null, null).getVisitor().visitNonNull((Tree)d, (Object)ctx);
            d = (Yaml.Documents)new DeleteKey("$..steps[?(@.uses =~ 'slackapi/slack-github-action@v1.*')].with.channel-id", null).getVisitor().visitNonNull((Tree)d, (Object)ctx);
            d = (Yaml.Documents)new DeleteKey("$..steps[?(@.uses =~ 'slackapi/slack-github-action@v1.*')].with.slack-message", null).getVisitor().visitNonNull((Tree)d, (Object)ctx);
            d = (Yaml.Documents)new DeleteKey("$..steps[?(@.uses =~ 'slackapi/slack-github-action@v1.*')].env.SLACK_BOT_TOKEN", null).getVisitor().visitNonNull((Tree)d, (Object)ctx);
            d = (Yaml.Documents)new ChangeValue("$..steps[?(@.uses =~ 'slackapi/slack-github-action@v1.*')].uses", "slackapi/slack-github-action@v2.0.0", null).getVisitor().visitNonNull((Tree)d, (Object)ctx);
            return this.autoFormat((Yaml)d, ctx, Objects.requireNonNull(this.getCursor().getParent()));
        }

        @Generated
        public UpgradeSlackNotificationActionVisitor() {
        }
    }
}

