/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;
import org.openrewrite.yaml.tree.YamlKey;

public final class ReplaceSecretKeys
extends Recipe {
    @Option(displayName="Old key name", description="The name of the key to be replaced", example="ossrh_username")
    private final String oldKeyName;
    @Option(displayName="New key name", description="The new key name to use", example="sonatype_username")
    private final String newKeyName;
    @Option(displayName="File matcher", description="Optional file path matcher", required=false, example=".github/workflows/*.yml")
    private final @Nullable String fileMatcher;

    public String getDisplayName() {
        return "Replace secret key names in GitHub Actions";
    }

    public String getDescription() {
        return "Replace key names used for secrets in GitHub Actions workflow files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(this.fileMatcher != null ? this.fileMatcher : ".github/workflows/*.yml"), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry e = super.visitMappingEntry(entry, (Object)ctx);
                if (e.getKey() instanceof Yaml.Scalar) {
                    Yaml.Scalar key = (Yaml.Scalar)e.getKey();
                    if (ReplaceSecretKeys.this.oldKeyName.equals(key.getValue())) {
                        return e.withKey((YamlKey)key.withValue(ReplaceSecretKeys.this.newKeyName));
                    }
                }
                return e;
            }
        });
    }

    @Generated
    public ReplaceSecretKeys(String oldKeyName, String newKeyName, @Nullable String fileMatcher) {
        this.oldKeyName = oldKeyName;
        this.newKeyName = newKeyName;
        this.fileMatcher = fileMatcher;
    }

    @Generated
    public String getOldKeyName() {
        return this.oldKeyName;
    }

    @Generated
    public String getNewKeyName() {
        return this.newKeyName;
    }

    @Generated
    public @Nullable String getFileMatcher() {
        return this.fileMatcher;
    }

    @Generated
    public String toString() {
        return "ReplaceSecretKeys(oldKeyName=" + this.getOldKeyName() + ", newKeyName=" + this.getNewKeyName() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceSecretKeys)) {
            return false;
        }
        ReplaceSecretKeys other = (ReplaceSecretKeys)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldKeyName = this.getOldKeyName();
        String other$oldKeyName = other.getOldKeyName();
        if (this$oldKeyName == null ? other$oldKeyName != null : !this$oldKeyName.equals(other$oldKeyName)) {
            return false;
        }
        String this$newKeyName = this.getNewKeyName();
        String other$newKeyName = other.getNewKeyName();
        if (this$newKeyName == null ? other$newKeyName != null : !this$newKeyName.equals(other$newKeyName)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReplaceSecretKeys;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldKeyName = this.getOldKeyName();
        result = result * 59 + ($oldKeyName == null ? 43 : $oldKeyName.hashCode());
        String $newKeyName = this.getNewKeyName();
        result = result * 59 + ($newKeyName == null ? 43 : $newKeyName.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

