/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.ChangeValue;

public final class ChangeAction
extends Recipe {
    @Option(displayName="Action", description="Name of the action to match.", example="gradle/wrapper-validation-action")
    private final String oldAction;
    @Option(displayName="Action", description="Name of the action to use instead.", example="gradle/actions/wrapper-validation")
    private final String newAction;
    @Option(displayName="Version", description="New version to use.", example="v3")
    private final String newVersion;

    public String getDisplayName() {
        return "Change GitHub Action";
    }

    public String getDescription() {
        return "Change a GitHub Action in any `.github/workflows/*.yml` file.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new ChangeValue("$.jobs..[?(@.uses =~ '" + this.oldAction + "(?:@.+)?')].uses", this.newAction + '@' + this.newVersion, null).getVisitor());
    }

    @Generated
    public ChangeAction(String oldAction, String newAction, String newVersion) {
        this.oldAction = oldAction;
        this.newAction = newAction;
        this.newVersion = newVersion;
    }

    @Generated
    public String getOldAction() {
        return this.oldAction;
    }

    @Generated
    public String getNewAction() {
        return this.newAction;
    }

    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public String toString() {
        return "ChangeAction(oldAction=" + this.getOldAction() + ", newAction=" + this.getNewAction() + ", newVersion=" + this.getNewVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeAction)) {
            return false;
        }
        ChangeAction other = (ChangeAction)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldAction = this.getOldAction();
        String other$oldAction = other.getOldAction();
        if (this$oldAction == null ? other$oldAction != null : !this$oldAction.equals(other$oldAction)) {
            return false;
        }
        String this$newAction = this.getNewAction();
        String other$newAction = other.getNewAction();
        if (this$newAction == null ? other$newAction != null : !this$newAction.equals(other$newAction)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldAction = this.getOldAction();
        result = result * 59 + ($oldAction == null ? 43 : $oldAction.hashCode());
        String $newAction = this.getNewAction();
        result = result * 59 + ($newAction == null ? 43 : $newAction.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        return result;
    }
}

